% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchresults.get.field.R
\name{searchresults.get.field}
\alias{searchresults.get.field}
\title{Perform a search using a specific field value}
\usage{
searchresults.get.field(term, field_type, field_key, exact_match = NULL,
  return_field_key = NULL, return_item_ids = NULL, start = NULL,
  limit = NULL, api_token = NULL, company_domain = "api")
}
\arguments{
\item{term}{Search term to look for, minimum 2 characters.}

\item{field_type}{Type of the field to perform the search from. This field has the following domains: (dealField; personField; organizationField; productField)}

\item{field_key}{Key of the field to search from. Field key can be obtained by fetching the list of fields using any of fields API GET methods (dealFields, personFields, ..).}

\item{exact_match}{When enabled, only full exact matches against the given term are returned. By default, term can be present anywhere in the resulting field values to be considered a match. The minimum 2 character limit for the term is discarded when exact_match is enabled. This field has the following domains: (0; 1)}

\item{return_field_key}{Name of the field in search results from which the search was performed. When omitted, 'value' will be used. You may want to set this parameter to match the field_key.}

\item{return_item_ids}{Whether to return matching items IDs in search results. When omitted or set to 0, only distinct values of the searched field are returned. When enabled, the return_field_key parameter is ignored and the results include the searched field as its own key. This field has the following domains: (0; 1)}

\item{start}{Pagination start}

\item{limit}{Items shown per page}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to Perform a search using a specific field value from pipedrive.
}
\examples{
\donttest{
searchresults.get.field(term='e.g.',field_type='e.g.',field_key='e.g.')
}
}
