\name{bond-angle-dihedral}
\alias{bond}
\alias{bond.coords}
\alias{bond.pdb}
\alias{angle}
\alias{angle.coords}
\alias{angle.pdb}
\alias{dihedral}
\alias{dihedral.coords}
\alias{dihedral.pdb}
\alias{measure}
\alias{measure.default}
\alias{measure.coords}
\alias{measure.pdb}
\title{Atomic Bond Lengths, Angles and Dihedrals}
\description{Compute bond lengths, angles and dihedral from atomic coordinates.}
\usage{
bond(...)
\method{bond}{coords}(x, sel1, sel2, ...)
\method{bond}{pdb}(x, sel1, sel2, ...)

angle(...)
\method{angle}{coords}(x, sel1, sel2, sel3, ...)
\method{angle}{pdb}(x, sel1, sel2, sel3, ...)

dihedral(...)
\method{dihedral}{coords}(x, sel1, sel2, sel3, sel4, ...)
\method{dihedral}{pdb}(x, sel1, sel2, sel3, sel4, ...)

measure(...)
\method{measure}{default}(id = rgl.ids(), verbose = TRUE, ...)
\method{measure}{coords}(x, id = rgl.ids(), verbose = TRUE, ...)
\method{measure}{pdb}(x, id = rgl.ids(), verbose = TRUE, ...)
}
\arguments{
  \item{x}{an R object containing atomic coordinates.}
  \item{sel1, sel2, sel3, sel4}{an integer or logical vector used to select atoms defining bonds, angles or dihedrals. See details.}
  \item{id}{vector of ID numbers of \sQuote{rgl} items, as returned by \code{rgl.ids}. The vertexes of these items are used to compute the bond lengths, angles or dihedrals.}
  \item{verbose}{a logical value specifying if the information have to be printed to the terminal.}
  \item{\dots}{further arguments passed to or from other methods.}
}
\details{The number of selected atoms with \code{sel1}, \code{sel2}, \code{sel3} and \code{sel4} must be the same. \code{sel1}, \code{sel2}, \code{sel3} and \code{sel4} respectively select the first, second, third and fouth atoms defining bonds, angles or dihedrals.\cr\cr
\code{measure} activate an interactive mode to compute bond lengths, angles and dihedrals by selecting atoms by \bold{right-clicing} on the current \sQuote{rgl} scene. To escape the active mode press the ESC key.
}
\value{A numeric vector containing atomic bond lengths (in Angstrom), angles or dihedrals (in degrees)}
\seealso{
\code{\link{coords}}, \code{\link{pdb}}, \code{\link{info3d}}, \code{\link{visualize}}
}
\examples{
Pen <- read.pdb(system.file("examples/Pentacene.pdb",package="Rpdb"))
visualize(Pen, mode = NULL)
text3d(coords(Pen), texts=Pen$atoms$eleid)
bond(Pen,3:4,1:2)
angle(Pen,3:4,1:2,5:6)
dihedral(Pen,3:4,1:2,5:6,6:5)
}
\keyword{ manip }
\keyword{ dynamic }
