% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rpcop.R
\name{pcop}
\alias{pcop}
\title{pcop}
\usage{
pcop(x, Ch = 1.5, Cd = 0.3, plot.true = FALSE, ...)
}
\arguments{
\item{x}{a matrix of n points in dimension p}

\item{Ch}{The smoothing parameter h is C_H times the value given by the normal reference rule.
Default value 1.5. Constraints 0.5 <= C_H <=  1.5}

\item{Cd}{The distance between two consecutive principal oriented points in a PCOP is about C_D times
the value of the smoothing parameter h.
Default value 0.3. Constraints 0.25 <= C_D <= .5}

\item{plot.true}{if TRUE, the function produces a plot}

\item{...}{Additional parameters passed to function "lines"}
}
\value{
A list with two data frames. One contains a list with the following names:
'param': Value of the parameter t such the the principal oriented point is PCOP(t).
'dens': Density estimation for the random variable induced over the PCOP at t.
'span': proportion of original data involved in the determination of the principal oriented point.
'orth.var': Variance over the hyperplane orthogonal to the PCOP at the principal oriented point.
'pop': a p-dimensional array. The p coordinates of the principal oriented point.
'pr.dir': a p-dimensional array. The p coordinates of the principal direction for the principal oriented point.
For the second, look at the package princurve.
}
\description{
Computes a principal curve of oriented points as defined in Delicado (2001).
}
\examples{
x <- runif(100,-1,1)
x <- cbind(x, x ^ 2 + rnorm(100, sd = 0.1))
pcop(x, plot.true=TRUE, lwd=4, col=2)
}
