% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureSelection.R
\name{FS.permutation.heuristic.reduct.RST}
\alias{FS.permutation.heuristic.reduct.RST}
\title{The permutation heuristic algorithm for computation of a decision reduct}
\usage{
FS.permutation.heuristic.reduct.RST(decision.table, permutation = NULL,
  decisionIdx = ncol(decision.table))
}
\arguments{
\item{decision.table}{an object of a \code{"DecisionTable"} class representing a decision table. See \code{\link{SF.asDecisionTable}}.}

\item{permutation}{a logical value, an integer vector or\code{NULL} (the default). If an integer vector with a length
equal the cardinality of the conditional attribute set of the decision table is given (it must contain a permutation of
integers from 1:(ncol(decision.table) - 1) ), then it will define the elimination order. Otherwise, if \code{permutation}
is \code{NULL} or \code{TRUE} a random permutation will be generated. In the case when \code{permutation} is FALSE, the
elimination will be performed in the order of attributes in the decision system.}

\item{decisionIdx}{an index of the decision attribute. The default value is the last column of a decision table.}
}
\value{
A class \code{"FeatureSubset"} that contains the following components:
\itemize{
\item \code{reduct}: a list representing a single reduct. In this case, it could be a superreduct or just a subset of features.
\item \code{type.method}: a string representing the type of method which is \code{"permutation.heuristic"}.
\item \code{type.task}: a string showing the type of task which is \code{"feature selection"}.
\item \code{model}: a string representing the type of model. In this case, it is \code{"RST"} which means rough set theory.
\item \code{epsilon}: the approximation threshold.
}
}
\description{
It is a function implementing the permutation heuristic approach based on RST.
}
\details{
Basically there are two steps in this algorithm which are
\itemize{
\item generating feature subset as a superreduct: In this step, we choose a subset of attributes that
      discern all object from different decision classes. It is done by adding consecutive attributes
      in an order defined by a permutation of attribute indices. The permutation can be random
      or it can be explicitly given (by the parameter \code{permutation}).
\item iterative elimination of attributes from the set obtained in the previous step.
      It is done in the reverse order to that, defined by the permutation.
}
More details regarding this algorithm can be found in (Janusz and Slezak, 2012).

Additionally, \code{\link{SF.applyDecTable}} has been provided to generate new decision table.
}
\examples{
###################################################
## Example 1: Generate reduct and new decision table
###################################################
data(RoughSetData)
decision.table <- RoughSetData$hiring.dt

## generate single reduct
res.1 <- FS.permutation.heuristic.reduct.RST(decision.table,
                                             permutation = NULL,
                                             decisionIdx = 5)
print(res.1)

res.2 <- FS.permutation.heuristic.reduct.RST(decision.table,
                                             permutation = 4:1,
                                             decisionIdx = 5)
print(res.2)

## generate new decision table according to the reduct
new.decTable <- SF.applyDecTable(decision.table, res.1)
}
\references{
A. Janusz and D. Ślęzak, "Utilization of Attribute Clustering Methods for Scalable Computation of Reducts from High-Dimensional Data".
Proceedings of Federated Conference on Computer Science and Information Systems - FedCSIS, p. 295 - 302 (2012).

Andrzej Janusz and Dominik Slezak. "Rough Set Methods for Attribute
Clustering and Selection". Applied Artificial Intelligence, 28(3):220–242, 2014.
}
\seealso{
\code{\link{FS.quickreduct.RST}} and \code{\link{FS.reduct.computation}}.
}
\author{
Andrzej Janusz
}
