% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Multirobu.R
\name{covRobMM}
\alias{covRobMM}
\alias{MMultiSHR}
\title{MM robust multivariate location and scatter estimator}
\usage{
covRobMM(X, maxit = 50, tolpar = 1e-04, cor = FALSE)
}
\arguments{
\item{X}{a data matrix with observations in rows.}

\item{maxit}{Maximum number of iterations.}

\item{tolpar}{Tolerance to decide converngence.}

\item{cor}{A logical value. If \code{TRUE} a correlation matrix is included in the element \code{cor} of the returned object. Defaults to \code{FALSE}.}
}
\value{
A list with class \dQuote{covRob} containing the following elements
\item{mu}{The location estimate}
\item{V}{The scatter or correlation matrix estimate, scaled for consistency at the normal distribution}
\item{center}{The location estimate. Same as \code{mu} above.}
\item{cov}{The scatter matrix estimate, scaled for consistency at the normal distribution. Same as \code{V} above.}
\item{cor}{The correlation matrix estimate, if the argument \code{cor} equals \code{TRUE}. Otherwise it is set to \code{NULL}.}
\item{dista}{Robust Mahalanobis distances}
}
\description{
This function computes an MM robust estimator for multivariate location and scatter with the "SHR" loss function.
}
\details{
This function computes an MM robust estimator for multivariate location and scatter with the "SHR" loss function.
}
\examples{
data(bus)
X0 <- as.matrix(bus)
X1 <- X0[,-9]
tmp <- covRobMM(X1)
round(tmp$cov[1:10, 1:10], 3)
tmp$mu

}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\author{
Ricardo Maronna, \email{rmaronna@retina.ar}
}
