% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-input-and-settings.R
\name{check_setup}
\alias{check_setup}
\title{Prints summary of \code{"RoBTT"} ensemble implied by the specified priors}
\usage{
check_setup(
  prior_delta = prior(distribution = "cauchy", parameters = list(location = 0, scale =
    sqrt(2)/2)),
  prior_rho = prior(distribution = "beta", parameters = list(alpha = 1, beta = 1)),
  prior_nu = prior(distribution = "exp", parameters = list(rate = 1)),
  prior_delta_null = prior(distribution = "spike", parameters = list(location = 0)),
  prior_rho_null = prior(distribution = "spike", parameters = list(location = 0.5)),
  prior_nu_null = prior_none(),
  prior_mu = NULL,
  prior_sigma2 = NULL,
  truncation = NULL,
  models = FALSE,
  silent = FALSE
)
}
\arguments{
\item{prior_delta}{prior distributions for the effect size \code{delta} parameter
that will be treated as belonging to the alternative hypothesis. Defaults to \code{
prior(distribution = "Cauchy", parameters = list(location = 0, scale = sqrt(2)/2))}.}

\item{prior_rho}{prior distributions for the precision allocation \code{rho} parameter
that will be treated as belonging to the alternative hypothesis. Defaults to \code{
prior(distribution = "beta", parameters = list(alpha = 1, beta = 1))}.}

\item{prior_nu}{prior distribution for the degrees of freedom + 2 \code{nu}
parameter that will be treated as belonging to the alternative hypothesis.
Defaults to \code{prior(distribution = "exp", parameters = list(rate = 1))} if no
\code{truncation} is specified. If \code{truncation} is specified, the default is
\code{NULL} (i.e., use only normal likelihood).}

\item{prior_delta_null}{prior distribution for the \code{delta} parameter that
will be treated as belonging to the null hypothesis. Defaults to point distribution
with location at 0 (
\code{prior(distribution = "point", parameters = list(location = 0))}).}

\item{prior_rho_null}{prior distribution for the \code{rho} parameter that
will be treated as belonging to the null hypothesis. Defaults to point distribution
with location at 0.5 (
\code{prior(distribution = "point", parameters = list(location = 0.5))}).}

\item{prior_nu_null}{prior distribution for the \code{nu} parameter
that will be treated as belonging to the null hypothesis. Defaults to \code{prior_none} (
(i.e., normal likelihood)).}

\item{prior_mu}{prior distribution for the grand mean parameter. Defaults to \code{NULL}
which sets Jeffreys prior for the grand mean in case of no truncation or an unit Cauchy
prior distributions for the grand mean in case of truncation (which greatly improves
sampling efficiency).}

\item{prior_sigma2}{prior distribution for the grand variance parameter. Defaults to \code{NULL}
which sets Jeffreys prior for the variance in case of no truncation or an exponential prior
distribution for the variance in case of truncation (which greatly improves sampling efficiency).}

\item{truncation}{an optional list specifying truncation applied to the data.
Defaults to \code{NULL}, i.e., no truncation was applied and the full likelihood is
applied. Alternative the truncation can be specified via a named list with:
\describe{
\item{\code{"x"}}{where \code{x} is a vector of two values specifying the lower
and upper truncation points common across the groups}
\item{\code{"x1"} and \code{"x2"}}{where \code{x1} is a vector of two values specifying
the lower and upper truncation points for the first group and \code{x2} is a vector of
two values specifying the lower and upper truncation points for the second group.}
\item{\code{"sigma"}}{where \code{sigma} corresponds to the number of standard deviations
from the common mean where the truncation points should be set.}
\item{\code{"sigma1"} and \code{"sigma2"}}{where \code{sigma1} corresponds to the number of
standard deviations from the mean of the first group where the truncation points should be set
and \code{sigma2} corresponds to the number of standard deviations from the mean of the second
group where the truncation points should be set.}
}}

\item{models}{should the models' details be printed.}

\item{silent}{do not print the results.}
}
\value{
\code{check_setup} invisibly returns list of summary tables.
}
\description{
\code{check_setup} prints summary of \code{"RoBTT"} ensemble
implied by the specified prior distributions. It is useful for checking
the ensemble configuration prior to fitting all of the models.
}
\seealso{
\code{\link[=RoBTT]{RoBTT()}}
}
