% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrynldata.R
\name{insertNlDataCol}
\alias{insertNlDataCol}
\title{Insert an aggregate nightlight data column in a country nightlights dataframe}
\usage{
insertNlDataCol(ctryNlDataDF, dataCol, nlStat, nlPeriod, nlType,
  configName, multiTileStrategy, multiTileMergeFun,
  removeGasFlares = TRUE)
}
\arguments{
\item{ctryNlDataDF}{dataframe with the country data to save}

\item{dataCol}{the numeric vector to be inserted as a column}

\item{nlStat}{the stat which produced the dataCol vector}

\item{nlPeriod}{the nlPeriod that the dataCol belongs to}

\item{nlType}{the type of nightlight data}

\item{configName}{character the type of raster being processed}

\item{multiTileStrategy}{character How to handle multiple tiles per nlPeriod}

\item{multiTileMergeFun}{character The function to use to merge tiles}

\item{removeGasFlares}{logical Whether to perform gas flare removal pre-processing}
}
\value{
the updated dataframe
}
\description{
Insert an aggregate nightlight data column in a country nightlights dataframe. The number
    of elements in the vector MUST match the number of rows in the country dataframe.
}
\examples{

\dontrun{
ctryNlDataDF <- Rnightlights:::insertNlDataCol(ctryNlDataDF, 
    dataCol, "sum", "201409", "VIIRS.D")
    }

\dontrun{
ctryNlDataDF <- Rnightlights:::insertNlDataCol(ctryNlDataDF, 
    dataCol, "mean", "2012", "OLS.Y")
    }

}
