% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{fnAggRadRast}
\alias{fnAggRadRast}
\title{Calculate statistics on a nightlight raster that fall within a polygon}
\usage{
fnAggRadRast(ctryPoly, ctryRastCropped, nlType, nlStats, custPolyPath = NULL)
}
\arguments{
\item{ctryPoly}{The polygon of the admin level/region of interest. In general is a country polygon
with sub-regions usually the lowest known admin level as given by the GADM polygons.}

\item{ctryRastCropped}{The raster containing nightlight radiances to sum. Usually will have already be
cropped to the country outline}

\item{nlType}{Character vector The nlType to process}

\item{nlStats}{The statistics to calculate}

\item{custPolyPath}{Alternative to GADM. A path to a custom shapefile zip}
}
\value{
data.frame of polygon attributes and the calculated stats, one column per nlStat
}
\description{
Calculate stats on the radiance of the pixels in a nightlight raster
    that fall within a polygon and its subpolygons using the \code{raster} 
    package. Given a country polygon with subpolygons representing lower 
    admin levels, it will crop and mask the raster to each subpolygon and 
    calculate the total radiance for the polygon and return a vector of total
    radiances that matches the subpolygons
}
\examples{
#read the Kenya polygon downloaded from GADM and load the lowest admin level (ward)
\dontrun{
ctryPoly <- readCtryPolyAdmLayer(ctryCode="KEN", 
    Rnightlights:::getCtryShpLowestLyrNames(ctryCodes="KEN"))
    
# the VIIRS nightlight raster cropped earlier to the country outline
ctryRastCropped <- raster::raster(Rnightlights:::getCtryRasterOutputFnamePath(ctryCode="KEN",
    nlType="VIIRS.M", nlPeriod="201401"))

#calculate the sum of radiances for the wards in Kenya
sumAvgRadRast <- Rnightlights:::fnAggRadRast(ctryPoly=ctryPoly,
    ctryRastCropped=ctryRastCropped, nlType="VIIRS.M", nlStats=c("sum","mean"))
}
}
