\name{responsecounts}
\alias{responsecounts}
\title{Get response counts}
\description{Get response counts for a survey collector}
\usage{
responsecounts(collector, api_key = getOption('sm_api_key'),
           oauth_token = getOption('sm_oauth_token'))
}
\arguments{
\item{collector}{A collector ID number (or an object of class \dQuote{sm_collector} from which it can be extracted), possibly returned by \code{\link{collectors}}.}
\item{api_key}{Your API key. By default, retrieved from \code{getOption('sm_api_key')}.}
\item{oauth_token}{Your OAuth 2.0 token, as generated by \code{\link{smlogin}}. By default, retrieved from \code{getOption('sm_oauth_token')}.}
%  \item{...}{Other arguments. Currently ignored.}
}
\details{Retrieves number of (started and completed) responses for a specified survey collector.}
\value{A list containing response counts.}
\references{
\url{https://developer.surveymonkey.com/mashery/get_response_counts}
}
\author{Thomas J. Leeper}
%\note{}
%\seealso{}
\examples{
\dontrun{
smlogin()
s <- surveylist()
lapply(collectors(s[[1]]$survey_id), function(x) responsecounts(x$collector_id))
}
}
%\keyword{}
