/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.util;

import java.io.IOException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.broker.util.CommandHandler;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.util.FactoryFinder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandMessageListener
implements MessageListener {
    private static final Log LOG = LogFactory.getLog(CommandMessageListener.class);
    private Session session;
    private MessageProducer producer;
    private CommandHandler handler;

    public CommandMessageListener(Session session) {
        this.session = session;
    }

    public void onMessage(Message message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received command: " + message);
        }
        if (message instanceof TextMessage) {
            TextMessage request = (TextMessage)message;
            try {
                Destination replyTo = message.getJMSReplyTo();
                if (replyTo == null) {
                    LOG.warn("Ignored message as no JMSReplyTo set: " + message);
                    return;
                }
                Message response = this.processCommand(request);
                this.addReplyHeaders(request, response);
                this.getProducer().send(replyTo, response);
            }
            catch (Exception e) {
                LOG.error("Failed to process message due to: " + e + ". Message: " + message, e);
            }
        } else {
            LOG.warn("Ignoring invalid message: " + message);
        }
    }

    protected void addReplyHeaders(TextMessage request, Message response) throws JMSException {
        String correlationID = request.getJMSCorrelationID();
        if (correlationID != null) {
            response.setJMSCorrelationID(correlationID);
        }
    }

    public Message processCommand(TextMessage request) throws Exception {
        TextMessage response = this.session.createTextMessage();
        this.getHandler().processCommand(request, response);
        return response;
    }

    public String processCommandText(String line) throws Exception {
        ActiveMQTextMessage request = new ActiveMQTextMessage();
        request.setText(line);
        ActiveMQTextMessage response = new ActiveMQTextMessage();
        this.getHandler().processCommand(request, response);
        return response.getText();
    }

    public Session getSession() {
        return this.session;
    }

    public MessageProducer getProducer() throws JMSException {
        if (this.producer == null) {
            this.producer = this.getSession().createProducer(null);
        }
        return this.producer;
    }

    public CommandHandler getHandler() throws IllegalAccessException, IOException, InstantiationException, ClassNotFoundException {
        if (this.handler == null) {
            this.handler = this.createHandler();
        }
        return this.handler;
    }

    private CommandHandler createHandler() throws IllegalAccessException, IOException, ClassNotFoundException, InstantiationException {
        FactoryFinder factoryFinder = new FactoryFinder("META-INF/services/org/apache/activemq/broker/");
        return (CommandHandler)factoryFinder.newInstance("agent");
    }
}

