% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/southAfrica.R
\name{southAfrica}
\alias{southAfrica}
\title{southAfrica}
\usage{
southAfrica(
  site,
  variable = "stage",
  start_date = NULL,
  end_date = NULL,
  sites = FALSE,
  ...
)
}
\arguments{
\item{site}{South African gauge number}

\item{variable}{Character. Either \code{stage} or \code{discharge}.}

\item{start_date}{Character. Optional start date with format
YYYY-MM-DD. Default is 1900-01-01.}

\item{end_date}{Character. End date with format YYYY-MM-DD.
Default is the current date.}

\item{sites}{Logical. If TRUE, returns a list of measurement
sites.}

\item{...}{Additional arguments. None implemented.}
}
\value{
data frame of discharge time-series
}
\description{
Retrieve South African gauge data
}
\examples{
\donttest{
site <- "X3H023"
start_date <- as.Date("2000-01-01")
end_date <- as.Date("2010-01-01")
x <- southAfrica(site, "stage", start_date, end_date)
}
}
