% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizations.R
\name{arcsineXform}
\alias{arcsineXform}
\title{Arcsine Transformation}
\usage{
arcsineXform(sample)
}
\arguments{
\item{sample}{The input data (vector)}
}
\value{
The arcsine-transformed data (vector)
}
\description{
This function transforms the scale, if needed, to values of unity.
Then, the data is transformed by taking the arcsine of each value.
Per the recommendations of Osborne(2002), data points are left-anchored
at 0 to maximize the efficacy of the square-root transformation used enroute
to the arcsine.
}
\examples{
values <- rnorm(100)
x <- arcsineXform(values)
}
\references{
Osborne, J. W. (2002). Notes on the use of data transformations. Practical Assessment, Research and Evaluation, 9(1), 42-50.

            Osborne, J. W. (2002). The Effects of Minimum Values on Data Transformations. Retrieved from https://files.eric.ed.gov/fulltext/ED463313.pdf
}
