% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IEX_Market_Data.R
\name{iex.book}
\alias{iex.book}
\title{Retrieves quote, bids, asks, trades and system event for each Stock Symbol}
\usage{
iex.book(x, iex_sk)
}
\arguments{
\item{x}{A charcter vector that can include one or multiple  Tickers / Stocks Symbols}

\item{iex_sk}{is a character vector that include IEX Cloud API Secret Token}
}
\value{
Data frame with stock(s) quote data
}
\description{
For more details, visit:\url{https://iexcloud.io/docs/api/#book}
}
\details{
for function like book(), only one value wil be accepted per request
}
\examples{
\donttest{
  iex.book("TSLA")
}
}
\seealso{
Investors Exchange `IEX` developer guide \url{https://iexcloud.io/docs/api/}

Investors Exchange Group (IEX Group) offers flexible and salable pricing.\url{https://iexcloud.io/pricing/}

View Investors Exchange Group (IEX Group) terms of use and subscription levels.\url{https://iexcloud.io/terms/}

Package `iexcloudR`\url{https://github.com/schardtbc/iexcloudR}
}
\author{
Myriam Ibrahim
}
