% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_sphere.R
\name{sphere.utest}
\alias{sphere.utest}
\title{Test of Uniformity on Sphere}
\usage{
sphere.utest(spobj, method = c("Rayleigh", "RayleighM"))
}
\arguments{
\item{spobj}{a S3 \code{"riemdata"} class for \eqn{N} Sphere-valued data.}

\item{method}{(case-insensitive) name of the test method containing \describe{
\item{\code{"Rayleigh"}}{original Rayleigh statistic.}
\item{\code{"RayleighM"}}{modified Rayleigh statistic with better order of error.}
}}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given \eqn{N} observations \eqn{\lbrace X_1, X_2, \ldots, X_M \brace} on 
\eqn{\mathcal{S}^{p-1}}, it tests whether the data is distributed uniformly 
on the sphere.
}
\examples{
#-------------------------------------------------------------------
#   Compare Rayleigh's original and modified versions of the test
#-------------------------------------------------------------------
#  Data Generation
myobj = sphere.runif(n=100, p=5, type="riemdata")

#  Compare 2 versions : Original vs Modified Rayleigh
sphere.utest(myobj, method="rayleigh")
sphere.utest(myobj, method="rayleighm")


}
\references{
\insertRef{chikuse_statistics_2003}{Riemann}

\insertRef{mardia_directional_1999}{Riemann}
}
\seealso{
\code{\link{wrap.sphere}}
}
\concept{sphere}
