% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference_fanova.R
\name{riem.fanova}
\alias{riem.fanova}
\alias{riem.fanovaP}
\title{Fréchet Analysis of Variance}
\usage{
riem.fanova(..., maxiter = 50, eps = 1e-05)

riem.fanovaP(..., maxiter = 50, eps = 1e-05, nperm = 99)
}
\arguments{
\item{...}{S3 objects of \code{riemdata} class for manifold-valued data.}

\item{maxiter}{maximum number of iterations to be run.}

\item{eps}{tolerance level for stopping criterion.}

\item{nperm}{the number of permutations for resampling-based test.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given sets of manifold-valued data \eqn{X^{(1)}_{1:{n_1}}, X^{(2)}_{1:{n_2}}, \ldots, X^{(m)}_{1:{n_m}}}, 
performs analysis of variance to test equality of distributions. This means, small \eqn{p}-value implies that 
at least one of the equalities does not hold.
}
\examples{
#-------------------------------------------------------------------
#            Example on Sphere : Uniform Samples
#
#  Each of 4 classes consists of 20 uniform samples from uniform 
#  density on 2-dimensional sphere S^2 in R^3.
#-------------------------------------------------------------------
## PREPARE DATA OF 4 CLASSES
ndata  = 20
class1 = list()
class2 = list()
class3 = list()
class4 = list()
for (i in 1:ndata){
  tmp = matrix(rnorm(4*3), ncol=3)
  tmp = tmp/sqrt(rowSums(tmp^2))
  
  class1[[i]] = tmp[1,]
  class2[[i]] = tmp[2,]
  class3[[i]] = tmp[3,]
  class4[[i]] = tmp[4,]
}
obj1 = wrap.sphere(class1)
obj2 = wrap.sphere(class2)
obj3 = wrap.sphere(class3)
obj4 = wrap.sphere(class4)

## RUN THE ASYMPTOTIC TEST
riem.fanova(obj1, obj2, obj3, obj4)

\donttest{
## RUN THE PERMUTATION TEST WITH MANY PERMUTATIONS
riem.fanovaP(obj1, obj2, obj3, obj4, nperm=9999)
}

}
\references{
\insertRef{dubey_frechet_2019}{Riemann}
}
\concept{inference}
