% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_forestry.R
\name{adaptiveForestry-forestry}
\alias{adaptiveForestry-forestry}
\alias{adaptiveForestry}
\title{forestry with adaptive featureWeights}
\usage{
adaptiveForestry(
  x,
  y,
  ntree = 500,
  ntree.first = 25,
  ntree.second = 500,
  replace = TRUE,
  sampsize = if (replace) nrow(x) else ceiling(0.632 * nrow(x)),
  sample.fraction = NULL,
  mtry = max(floor(ncol(x)/3), 1),
  nodesizeSpl = 5,
  nodesizeAvg = 5,
  nodesizeStrictSpl = 1,
  nodesizeStrictAvg = 1,
  minSplitGain = 0,
  maxDepth = round(nrow(x)/2) + 1,
  interactionDepth = maxDepth,
  interactionVariables = numeric(0),
  featureWeights = NULL,
  deepFeatureWeights = NULL,
  observationWeights = NULL,
  splitratio = 1,
  OOBhonest = FALSE,
  seed = as.integer(runif(1) * 1000),
  verbose = FALSE,
  nthread = 0,
  splitrule = "variance",
  middleSplit = FALSE,
  maxObs = length(y),
  linear = FALSE,
  linFeats = 0:(ncol(x) - 1),
  monotonicConstraints = rep(0, ncol(x)),
  monotoneAvg = FALSE,
  overfitPenalty = 1,
  doubleTree = FALSE,
  reuseforestry = NULL,
  savable = TRUE,
  saveable = TRUE
)
}
\arguments{
\item{x}{A data frame of all training predictors.}

\item{y}{A vector of all training responses.}

\item{ntree}{The number of trees to grow in the forest. The default value is
500.}

\item{ntree.first}{The number of trees to grow in the first forest when
trying to determine which features are important.}

\item{ntree.second}{The number of features to use in the second stage when
we grow a second forest using the weights of the first stage.}

\item{replace}{An indicator of whether sampling of training data is with
replacement. The default value is TRUE.}

\item{sampsize}{The size of total samples to draw for the training data. If
sampling with replacement, the default value is the length of the training
data. If sampling without replacement, the default value is two-thirds of
the length of the training data.}

\item{sample.fraction}{If this is given, then sampsize is ignored and set to
be round(length(y) * sample.fraction). It must be a real number between 0 and 1}

\item{mtry}{The number of variables randomly selected at each split point.
The default value is set to be one-third of the total number of features of the training data.}

\item{nodesizeSpl}{Minimum observations contained in terminal nodes.
The default value is 5.}

\item{nodesizeAvg}{Minimum size of terminal nodes for averaging dataset.
The default value is 5.}

\item{nodesizeStrictSpl}{Minimum observations to follow strictly in terminal nodes.
The default value is 1.}

\item{nodesizeStrictAvg}{The minimum size of terminal nodes for averaging data set to follow when predicting.
No splits are allowed that result in nodes with observations less than this parameter.
This parameter enforces overlap of the averaging data set with the splitting set when training.
When using honesty, splits that leave less than nodesizeStrictAvg averaging
observations in either child node will be rejected, ensuring every leaf node
also has at least nodesizeStrictAvg averaging observations. The default value is 1.}

\item{minSplitGain}{Minimum loss reduction to split a node further in a tree.}

\item{maxDepth}{Maximum depth of a tree. The default value is 99.}

\item{interactionDepth}{All splits at or above interaction depth must be on
variables that are not weighting variables (as provided by the interactionVariables argument).}

\item{interactionVariables}{Indices of weighting variables.}

\item{featureWeights}{(optional) vector of sampling probabilities/weights for each
feature used when subsampling mtry features at each node above or at interactionDepth.
The default is to use uniform probabilities.}

\item{deepFeatureWeights}{Used in place of featureWeights for splits below interactionDepth.}

\item{observationWeights}{Denotes the weights for each training observation
that determine how likely the observation is to be selected in each bootstrap sample.
This option is not allowed when sampling is done without replacement.}

\item{splitratio}{Proportion of the training data used as the splitting dataset.
It is a ratio between 0 and 1. If the ratio is 1 (the default), then the splitting
set uses the entire data, as does the averaging set---i.e., the standard Breiman RF setup.
If the ratio is 0, then the splitting data set is empty, and the entire dataset is used
for the averaging set (This is not a good usage, however, since there will be no data available for splitting).}

\item{OOBhonest}{In this version of honesty, the out-of-bag observations for each tree
are used as the honest (averaging) set. This setting also changes how predictions
are constructed. When predicting for observations that are out-of-sample
(using Predict(..., aggregation = "average")), all the trees in the forest
are used to construct predictions. When predicting for an observation that was in-sample (using
predict(..., aggregation = "oob")), only the trees for which that observation
was not in the averaging set are used to construct the prediction for that observation.
aggregation="oob" (out-of-bag) ensures that the outcome value for an observation
is never used to construct predictions for a given observation even when it is in sample.
This property does not hold in standard honesty, which relies on an asymptotic subsampling argument.}

\item{seed}{random seed}

\item{verbose}{Indicator to train the forest in verbose mode}

\item{nthread}{Number of threads to train and predict the forest. The default
number is 0 which represents using all cores.}

\item{splitrule}{Only variance is implemented at this point and it
specifies the loss function according to which the splits of random forest
should be made.}

\item{middleSplit}{Indicator of whether the split value is takes the average of two feature
values. If FALSE, it will take a point based on a uniform distribution
between two feature values. (Default = FALSE)}

\item{maxObs}{The max number of observations to split on.}

\item{linear}{Indicator that enables Ridge penalized splits and linear aggregation
functions in the leaf nodes. This is recommended for data with linear outcomes.
For implementation details, see: https://arxiv.org/abs/1906.06463. Default is FALSE.}

\item{linFeats}{A vector containing the indices of which features to split
linearly on when using linear penalized splits (defaults to use all numerical features).}

\item{monotonicConstraints}{Specifies monotonic relationships between the continuous
features and the outcome. Supplied as a vector of length p with entries in
1,0,-1 which 1 indicating an increasing monotonic relationship, -1 indicating
a decreasing monotonic relationship, and 0 indicating no constraint.
Constraints supplied for categorical variable will be ignored.}

\item{monotoneAvg}{This is a boolean flag that indicates whether or not monotonic
constraints should be enforced on the averaging set in addition to the splitting set.
This flag is meaningless unless both honesty and monotonic constraints are in use.
The default is FALSE.}

\item{overfitPenalty}{Value to determine how much to penalize the magnitude
of coefficients in ridge regression when using linear splits.}

\item{doubleTree}{if the number of tree is doubled as averaging and splitting
data can be exchanged to create decorrelated trees. (Default = FALSE)}

\item{reuseforestry}{Pass in an `forestry` object which will recycle the
dataframe the old object created. It will save some space working on the
same data set.}

\item{savable}{If TRUE, then RF is created in such a way that it can be
saved and loaded using save(...) and load(...). However, setting it to TRUE
(default) will take longer and use more memory. When
training many RF, it makes sense to set this to FALSE to save time and memory.}

\item{saveable}{deprecated. Do not use.}
}
\value{
Two forestry objects, the first forest, and the adaptive forest,
  as well as the splitting proportions used to grow the second forest.
}
\description{
This is an experimental function where we run forestry in two
  stages, first estimating the feature weights by calculating the relative
  splitting proportions of each feature using a small forest, and then
  growing a much bigger forest using the
  first forest splitting proportions as the featureWeights in the second forest.
}
\details{
adaptiveForestry
}
\examples{

# Set seed for reproductivity
set.seed(292313)

# Use Iris Data
test_idx <- sample(nrow(iris), 11)
x_train <- iris[-test_idx, -1]
y_train <- iris[-test_idx, 1]
x_test <- iris[test_idx, -1]

rf <- adaptiveForestry(x = x_train,
                        y = y_train,
                        ntree.first = 25,
                        ntree.second = 500,
                        nthread = 2)
predict(rf@second.forest, x_test)

}
