score.gammaregs <- function(y, x, logged = FALSE) {
  pa <- gammamle(y)$param
  m <- pa[1]/pa[2]
  u <- colsums(x) - colsums(y * x)/m
  vb <- colsums(x^2)/(m * pa[2] )
  stat <- u^2/vb
  pvalue <- pchisq(stat, 1, lower.tail = FALSE, log.p = logged)
  cbind(stat, pvalue)
} 