% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processDivRates.R
\name{processDivRates}
\alias{processDivRates}
\title{Process Diversification Rates}
\usage{
processDivRates(
  speciation_time_log = "",
  speciation_rate_log = "",
  extinction_time_log = "",
  extinction_rate_log = "",
  fossilization_time_log = "",
  fossilization_rate_log = "",
  burnin = 0.25,
  probs = c(0.025, 0.975),
  summary = "mean"
)
}
\arguments{
\item{speciation_time_log}{(vector of character strings or
single character string; "") Path to speciation times log file(s)}

\item{speciation_rate_log}{(vector of character strings or
single character string; "") Path to speciation rates log file(s)}

\item{extinction_time_log}{(vector of character strings or
single character string; "") Path to extinction times log file(s)}

\item{extinction_rate_log}{(vector of character strings or
single character string; "") Path to extinction rates log file(s)}

\item{fossilization_time_log}{(vector of character strings or
single character string; "") Path to fossilization times log file(s)}

\item{fossilization_rate_log}{(vector of character strings or
single character string; "") Path to fossilization rates log file(s)}

\item{burnin}{(single numeric value; default = 0) Fraction of generations to
discard (if value provided is between 0 and 1) or number of generations (if
value provided is greater than 1). Passed to readTrace().}

\item{probs}{(numeric vector; c(0.025, 0.975)) a vector of length two
containing the upper and lower bounds for the confidence intervals.}

\item{summary}{typically "mean" or "median"; the metric to summarize the
posterior distribution. Defaults to "Mean"}
}
\value{
List object with processed rate and time parameters.
}
\description{
Processing the output of a episodic diversification rate analysis with
mass-extinction events.
}
\details{
For processing the output of an episodic diversification rate analysis.
processDivRates() assumes that the epochs are fixed rather than inferred.
Additionally, it assumes that times correspond to rates such that the first
rate parameter (i.e. speciation[1]) corresponds to the present. Conversely,
the first time parameter (i.e. interval_times[1]) corresponds to the first
time interval after the present, moving backwards in time. processDivRates()
relies on readTrace and produces a list object that can be read by
plotDivRates() to visualize the results. For now, only one log file per
parameter type is accepted (i.e. log files from multiple runs must be
combined before reading into the function).
}
\examples{

\donttest{
# download the example datasets to working directory

url_ex_times <-
   "https://revbayes.github.io/tutorials/intro/data/primates_EBD_extinction_times.log"
dest_path_ex_times <- "primates_EBD_extinction_times.log"
download.file(url_ex_times, dest_path_ex_times)

url_ex_rates <-
   "https://revbayes.github.io/tutorials/intro/data/primates_EBD_extinction_rates.log"
dest_path_ex_rates <- "primates_EBD_extinction_rates.log"
download.file(url_ex_rates, dest_path_ex_rates)

url_sp_times <-
   "https://revbayes.github.io/tutorials/intro/data/primates_EBD_speciation_times.log"
dest_path_sp_times <- "primates_EBD_speciation_times.log"
download.file(url_sp_times, dest_path_sp_times)

url_sp_rates <-
   "https://revbayes.github.io/tutorials/intro/data/primates_EBD_speciation_rates.log"
dest_path_sp_rates <- "primates_EBD_speciation_rates.log"
download.file(url_sp_rates, dest_path_sp_rates)

# to run on your own data, change this to the path to your data file
speciation_time_file <- dest_path_sp_times
speciation_rate_file <- dest_path_sp_rates
extinction_time_file <- dest_path_ex_times
extinction_rate_file <- dest_path_ex_rates

rates <- processDivRates(speciation_time_log = speciation_time_file,
                         speciation_rate_log = speciation_rate_file,
                         extinction_time_log = extinction_time_file,
                         extinction_rate_log = extinction_rate_file,
                         burnin = 0.25)

# remove files
# WARNING: only run for example dataset!
# otherwise you might delete your data!
file.remove(dest_path_sp_times, dest_path_ex_times,
            dest_path_sp_rates, dest_path_ex_rates)
}

}
