% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAncStatesMAP.R
\name{plotAncStatesMAP}
\alias{plotAncStatesMAP}
\title{plot Ancestral States MAP}
\usage{
plotAncStatesMAP(
  t,
  cladogenetic = FALSE,
  tip_labels = TRUE,
  tip_labels_size = 2,
  tip_labels_offset = 1,
  tip_labels_italics = FALSE,
  tip_labels_formatted = FALSE,
  tip_labels_remove_underscore = TRUE,
  tip_labels_states = FALSE,
  tip_labels_states_size = 2,
  tip_labels_states_offset = 0.1,
  node_labels_as = NULL,
  node_labels_size = 2,
  node_labels_offset = 0.1,
  node_labels_centered = FALSE,
  node_size_as = "state_posterior",
  node_color_as = "state",
  node_shape_as = NULL,
  node_shape = 19,
  node_color = "default",
  node_size = c(2, 6),
  tip_states = TRUE,
  tip_states_size = node_size,
  tip_states_shape = node_shape,
  state_transparency = 0.75,
  tree_layout = "rectangular",
  timeline = FALSE,
  geo = timeline,
  geo_units = list("epochs", "periods"),
  time_bars = timeline,
  ...
)
}
\arguments{
\item{t}{(treedata object; none) Output of processAncStates() function
containing tree and ancestral states.}

\item{cladogenetic}{(logical; FALSE) Plot shoulder states of cladogenetic
analyses?}

\item{tip_labels}{(logical; TRUE) Label taxa labels at tips?}

\item{tip_labels_size}{(numeric; 2) Size of tip labels.}

\item{tip_labels_offset}{(numeric; 1) Horizontal offset of tip labels from
tree.}

\item{tip_labels_italics}{(logical; FALSE) Italicize tip labels?}

\item{tip_labels_formatted}{(logical; FALSE) Do the tip labels contain 
manually added formatting information? Will set parse = TRUE in geom_text()
and associated functions to interpret formatting. See ?plotmath for more.
Cannot be TRUE if tip_labels_italics = TRUE.}

\item{tip_labels_remove_underscore}{(logical; TRUE) Remove underscores from
tip labels?}

\item{tip_labels_states}{(logical; FALSE) Optional plotting of text at tips
in addition
to taxa labels.}

\item{tip_labels_states_size}{(numeric; 2) Size of state labels at tips.
Ignored if
tip_labels_states is FALSE.}

\item{tip_labels_states_offset}{(numeric; 0.1) Horizontal offset of tip
state labels.
Ignored if tip_labels_states = NULL.}

\item{node_labels_as}{(character; NULL) Optional plotting of text at nodes.
Possible values are "state" for the ancestral states , "state_posterior"
for posterior probabilities of the estimated ancestral state,
"node_posterior" or the posterior probability of the node on the tree,
or NULL for not plotting any text at the nodes (default).}

\item{node_labels_size}{(numeric; 2) Size of node labels text. Ignored if
node_labels_as = NULL.}

\item{node_labels_offset}{(numeric; 0.1) Horizontal offset of node labels
from nodes. Ignored if node_labels_as = NULL.}

\item{node_labels_centered}{(logical; FALSE) Should node labels be centered
over the nodes? Defaults to FALSE: adjusting node labels to the right of
nodes and left of shoulders.}

\item{node_size_as}{(character; "state_posterior") How to vary size of
node symbols. Options are "state_posterior" (default) for posterior
probabilities of the estimated ancestral state, "node_posterior" or the
posterior probability of the node on the tree, "state" for vary size by the
ancestral state itself in cases where there are many character states
(e.g. chromosome numbers; we do not recommend this option for characters
with few states), or NULL for fixed symbol size.}

\item{node_color_as}{(character; "state") How to vary to color of node
symbols. Options are "state" (default) to vary by estimated ancestral states,
"state_posterior" for posterior probabilities of the estimated ancestral
state, "node_posterior" or the posterior probability of the node on the tree,
or NULL to set all as one color.}

\item{node_shape_as}{(character; NULL) Option to vary node symbol by shape.
Options are NULL to keep shape constant or "state" to vary shape by
ancestral state.}

\item{node_shape}{(integer; 19) Shape type for nodes. If node_shape_as =
"state", provide a vector with length of the number of states. See ggplot2
documentation for details:
\url{https://ggplot2.tidyverse.org/articles/ggplot2-specs.html#point}}

\item{node_color}{("character"; "default") Colors for node symbols. Defaults
to default RevGadgets colors. If node_color_as = "state', provide a vector of
length of the character states. If your color vector is labeled with state
labels, the legend will be displayed in the order of the labels. If
node_color_as = "posterior", provide a vector of length 2 to generate a
color gradient.}

\item{node_size}{(numeric; c(2, 6)) Range of sizes, or fixed size, for node
symbols. If node_size_as = "state_posterior", "node_posterior", or "state",
numeric vector of length two. If node_size_as = NULL, numeric vector of
length one. Size regulates the area of the symbol, following ggplot2 best
practices: \url{https://ggplot2.tidyverse.org/reference/scale_size.html})}

\item{tip_states}{(logical; TRUE) Plot states of taxa at tips?}

\item{tip_states_size}{(numeric; node_size) Size for tip symbols. Defaults
to the same size as node symbols.}

\item{tip_states_shape}{(integer; node_shape) Shape for tip symbols.
Defaults to the same as node symbols.}

\item{state_transparency}{(integer; 0.75) Alpha (transparency) of state
symbols- varies from 0 to 1.}

\item{tree_layout}{(character; "rectangular") Tree shape layout, passed to
ggtree(). Options are 'rectangular', 'slanted', 'ellipse', 'roundrect',
'fan', 'circular', 'inward_circular', 'radial', 'equal_angle', 'daylight'
or 'ape'. When cladogenetic = TRUE, only "rectangular" and 'circular' are
available.}

\item{timeline}{(logical; FALSE) Plot time tree with labeled x-axis with
timescale in MYA.}

\item{geo}{(logical; timeline) Add a geological timeline? Defaults to the
same as timeline.}

\item{geo_units}{(list; list("epochs", "periods")) Which geological units to
include in the geo timescale. May be "periods", "epochs", "stages", "eons", 
"eras", or a list of two of those units.}

\item{time_bars}{(logical; timeline) Add vertical gray bars to indicate
geological timeline units if geo == TRUE or regular time intervals (in MYA)
if geo == FALSE.}

\item{...}{(various) Additional arguments passed to ggtree::ggtree().}
}
\value{
A ggplot object
}
\description{
Plots the MAP estimates of ancestral states. Can accommodate cladogenetic
reconstructions by plotting on shoulders. Defaults to varying the symbols by
color to indicate estimated ancestral state and varying the size of the
symbol to indicate the posterior probability of that estimate, but symbol
shape may also vary to accommodate black and white figures. For more details
on the aesthetics options, see parameter details below. For data with many
character states (such as chromosome counts), vary the size of the symbol
by estimated ancestral state, and vary the posterior probability of that
estimate by a color gradient. Text labels at nodes and tips are also
available.
}
\examples{

\donttest{
# Standard ancestral state reconstruction example with various aesthetics

# process file
file <- system.file("extdata",
                    "comp_method_disc/ase_freeK.tree",
                    package="RevGadgets")
example <- processAncStates(file,
                            state_labels = c("1" = "Awesome",
                                             "2" = "Beautiful",
                                             "3" = "Cool!"))

# have states vary by color and indicate state pp with size (default)
plotAncStatesMAP(t = example)

# have states vary by color and indicate state pp with size ,
# and add a timeline
plotAncStatesMAP(t = example, timeline = TRUE)

# have states vary by color and symbol, label nodes with pp of states
plotAncStatesMAP(t = example,  node_shape_as = "state",
                 node_size = 4, node_shape = c(15, 17,20),
                 node_size_as = NULL, node_labels_as = "state_posterior")

# black and white figure - state as symbols and state pp with text
plotAncStatesMAP(t = example, node_color_as = NULL,
                 node_shape_as = "state", node_shape =  c(15, 17,20),
                 node_size_as = NULL, node_size = 4,
                 node_labels_as = "state_posterior",
                 node_color = "grey", state_transparency = 1)

# default with circular tree
plotAncStatesMAP(t = example, tree_layout = "circular")


# Chromosome evolution example

# process file
file <- system.file("extdata",
                    "chromo/ChromEvol_simple_final.tree",
                    package="RevGadgets")
chromo_example <- processAncStates(file, labels_as_numbers = TRUE)

# plot
plotAncStatesMAP(t = chromo_example, node_color_as = "state_posterior",
                 node_size_as = "state", node_color = colFun(2),
                 tip_labels_offset = 0.005, node_labels_as = "state",
                 node_labels_offset = 0, tip_labels_states = TRUE,
                 tip_labels_states_offset = 0, tip_states = FALSE)

# DEC example (cladogenetic)

# process file
file <- system.file("extdata", "dec/simple.ase.tre", package="RevGadgets")
labs <- c("1" = "K", "2" = "O", "3" = "M", "4" = "H", "5" = "KO",
"6" = "KM", "7" = "OM", "8" = "KH", "9" = "OH", "10" = "MH", "11" = "KOM",
"12" = "KOH", "13" = "KMH", "14" = "OMH", "15" = "KOMH")
dec_example <- processAncStates(file, state_labels = labs)

# plot
plotAncStatesMAP(t = dec_example,
                 cladogenetic = TRUE,
                 tip_labels_offset = 0.5)
}

}
