/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import java.util.List;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.Writer;
import org.docx4j.convert.out.common.writer.AbstractTableWriter;
import org.docx4j.convert.out.common.writer.AbstractTableWriterModel;
import org.docx4j.convert.out.common.writer.AbstractTableWriterModelCell;
import org.docx4j.convert.out.html.HtmlCssHelper;
import org.docx4j.model.properties.Property;
import org.docx4j.model.styles.Node;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.model.styles.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableWriter
extends AbstractTableWriter {
    protected static final Logger logger = LoggerFactory.getLogger(TableWriter.class);
    protected static final String TABLE_BORDER_MODEL = "border-collapse";
    protected static final String TABLE_INDENT = "margin-left";

    public static String getId(int idx) {
        return "docx4j_tbl_" + idx;
    }

    @Override
    protected Logger getLog() {
        return logger;
    }

    @Override
    protected Element createNode(Document doc, int nodeType) {
        Element ret = null;
        switch (nodeType) {
            case 0: {
                ret = doc.createElement("table");
                break;
            }
            case 1: {
                ret = doc.createElement("colgroup");
                break;
            }
            case 2: {
                ret = doc.createElement("col");
                break;
            }
            case 3: {
                ret = doc.createElement("thead");
                break;
            }
            case 4: {
                ret = doc.createElement("tr");
                break;
            }
            case 5: {
                ret = doc.createElement("th");
                break;
            }
            case 6: {
                ret = doc.createElement("tbody");
                break;
            }
            case 7: {
                ret = doc.createElement("tr");
                break;
            }
            case 8: {
                ret = doc.createElement("td");
            }
        }
        return ret;
    }

    @Override
    protected void applyAttributes(AbstractWmlConversionContext context, List<Property> properties, Element element) {
        HtmlCssHelper.applyAttributes(properties, element);
    }

    @Override
    protected void applyTableCustomAttributes(AbstractWmlConversionContext context, AbstractTableWriterModel table, Writer.TransformState transformState, Element tableRoot) {
        int cellSpacing;
        int n = cellSpacing = table.getEffectiveTableStyle().getTblPr() != null && table.getEffectiveTableStyle().getTblPr().getTblCellSpacing() != null && table.getEffectiveTableStyle().getTblPr().getTblCellSpacing().getW() != null ? table.getEffectiveTableStyle().getTblPr().getTblCellSpacing().getW().intValue() : 0;
        if (table.getStyleId() == null) {
            this.getLog().debug("table has no w:tblStyle?");
        } else {
            StyleTree styleTree = context.getWmlPackage().getMainDocumentPart().getStyleTree();
            Tree<StyleTree.AugmentedStyle> tTree = styleTree.getTableStylesTree();
            Node<StyleTree.AugmentedStyle> asn = tTree.get(table.getStyleId());
            tableRoot.setAttribute("class", StyleTree.getHtmlClassAttributeValue(tTree, asn));
        }
        tableRoot.setAttribute("id", TableWriter.getId(((AbstractTableWriter.TableModelTransformState)transformState).getIdx()));
        ((AbstractTableWriter.TableModelTransformState)transformState).incrementIdx();
        if (cellSpacing > 0) {
            HtmlCssHelper.appendStyle(tableRoot, Property.composeCss(TABLE_BORDER_MODEL, "separate"));
            tableRoot.setAttribute("cellspacing", this.convertToPixels(cellSpacing * 2));
        } else {
            HtmlCssHelper.appendStyle(tableRoot, Property.composeCss(TABLE_BORDER_MODEL, "collapse"));
        }
        if (table.getTableWidth() > 0) {
            HtmlCssHelper.appendStyle(tableRoot, Property.composeCss("width", UnitsOfMeasurement.twipToBest(table.getTableWidth())));
        }
    }

    protected String convertToPixels(int twips) {
        float pixels = 96.0f * (float)twips / 1440.0f;
        if (twips > 0 && pixels < 1.0f) {
            pixels = 1.0f;
        }
        return UnitsOfMeasurement.format2DP.format(pixels) + "px";
    }

    @Override
    protected void applyColumnCustomAttributes(AbstractWmlConversionContext context, AbstractTableWriterModel table, Writer.TransformState transformState, Element column, int columnIndex, int columnWidth) {
        if (table.getTableWidth() > 0 && columnWidth > -1) {
            HtmlCssHelper.appendStyle(column, Property.composeCss("width", UnitsOfMeasurement.format2DP.format(100.0f * (float)columnWidth / (float)table.getTableWidth()) + "%"));
        }
    }

    @Override
    protected void applyTableCellCustomAttributes(AbstractWmlConversionContext context, AbstractTableWriterModel table, Writer.TransformState transformState, AbstractTableWriterModelCell tableCell, Element cellNode, boolean isHeader, boolean isDummyCell) {
        if (isDummyCell) {
            HtmlCssHelper.appendStyle(cellNode, Property.composeCss("border", "none"));
            HtmlCssHelper.appendStyle(cellNode, Property.composeCss("background-color:", "transparent"));
        }
        if (tableCell.getExtraCols() > 0) {
            cellNode.setAttribute("colspan", Integer.toString(tableCell.getExtraCols() + 1));
        }
        if (tableCell.getExtraRows() > 0) {
            cellNode.setAttribute("rowspan", Integer.toString(tableCell.getExtraRows() + 1));
        }
    }
}

