/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.structure;

import java.util.ArrayList;
import java.util.List;
import org.docx4j.model.structure.HeaderFooterPolicy;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTSettings;
import org.docx4j.wml.Document;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.SectPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentModel {
    protected static Logger log = LoggerFactory.getLogger(DocumentModel.class);
    private List<SectionWrapper> sections;
    private WordprocessingMLPackage wordMLPackage;

    public DocumentModel(WordprocessingMLPackage wordMLPackage) {
        this.wordMLPackage = wordMLPackage;
        this.refresh();
    }

    public void refresh() {
        RelationshipsPart rels = this.wordMLPackage.getMainDocumentPart().getRelationshipsPart();
        Document doc = (Document)this.wordMLPackage.getMainDocumentPart().getJaxbElement();
        HeaderFooterPolicy previousHF = null;
        BooleanDefaultTrue evenAndOddHeaders = null;
        if (this.wordMLPackage.getMainDocumentPart().getDocumentSettingsPart() != null && this.wordMLPackage.getMainDocumentPart().getDocumentSettingsPart().getJaxbElement() != null) {
            evenAndOddHeaders = ((CTSettings)this.wordMLPackage.getMainDocumentPart().getDocumentSettingsPart().getJaxbElement()).getEvenAndOddHeaders();
        }
        this.sections = new ArrayList<SectionWrapper>();
        for (Object o : doc.getBody().getContent()) {
            PPr ppr;
            if (!(o instanceof P) || ((P)o).getPPr() == null || (ppr = ((P)o).getPPr()).getSectPr() == null) continue;
            SectionWrapper sw = new SectionWrapper(ppr.getSectPr(), previousHF, rels, evenAndOddHeaders);
            this.sections.add(sw);
            previousHF = sw.getHeaderFooterPolicy();
            log.debug("registered sectpr");
        }
        SectPr sectPr = doc.getBody().getSectPr();
        SectionWrapper sw = new SectionWrapper(sectPr, previousHF, rels, evenAndOddHeaders);
        this.sections.add(sw);
    }

    public List<SectionWrapper> getSections() {
        return this.sections;
    }
}

