/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.JaxbXmlPartXPathAware;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.wml.CTSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentSettingsPart
extends JaxbXmlPartXPathAware<CTSettings> {
    private static final Logger log = LoggerFactory.getLogger(DocumentSettingsPart.class);

    public DocumentSettingsPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public DocumentSettingsPart() throws InvalidFormatException {
        super(new PartName("/word/settings.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/settings");
    }

    @Override
    protected void setMceIgnorable() {
        boolean needW14 = false;
        if (((CTSettings)this.jaxbElement).getDocId14() != null) {
            needW14 = true;
        } else if (((CTSettings)this.jaxbElement).getConflictMode() != null) {
            needW14 = true;
        } else if (((CTSettings)this.jaxbElement).getDiscardImageEditingData() != null) {
            needW14 = true;
        } else if (((CTSettings)this.jaxbElement).getDefaultImageDpi() != null) {
            needW14 = true;
        }
        boolean needW15 = false;
        if (((CTSettings)this.jaxbElement).getChartTrackingRefBased() != null) {
            needW15 = true;
        } else if (((CTSettings)this.jaxbElement).getDocId15() != null) {
            needW15 = true;
        }
        String mceIgnorableVal = "";
        if (needW14) {
            mceIgnorableVal = "w14";
        }
        if (needW15) {
            mceIgnorableVal = mceIgnorableVal + " w15";
        }
        log.warn(mceIgnorableVal);
        ((CTSettings)this.jaxbElement).setIgnorable(mceIgnorableVal);
    }
}

