\name{raphael.html}
\alias{raphael.html}
\title{get HTML code from a plot}
\usage{
raphael.html(fun, pointsize = getOption("ReporteRs-fontsize"), width = 6,
  height = 6, fontname = getOption("ReporteRs-default-font"),
  canvas_id = 0, par.properties = parCenter(padding = 5), ...)
}
\arguments{
  \item{fun}{plot function}

  \item{width}{plot width in inches (default value is 6).}

  \item{height}{plot height in inches (default value is
  6).}

  \item{pointsize}{the default pointsize of plotted text in
  points, default to 12.}

  \item{fontname}{the default font family to use, default
  to getOption("ReporteRs-default-font").}

  \item{canvas_id}{canvas id - an integer - unique id in
  the web page}

  \item{par.properties}{paragraph formatting properties of
  the paragraph that contains images. An object of class
  \code{\link{parProperties}}}

  \item{...}{arguments for \code{fun}.}
}
\value{
an html string.
}
\description{
get HTML code from a plot
}
\examples{
\donttest{

# load ggplot2
if( requireNamespace("ggplot2", quietly = TRUE) ){
	
  # create a ggplot2 plot
  myplot = ggplot2::qplot(Sepal.Length, Petal.Length, data = iris
    , color = Species, size = Petal.Width, alpha = I(0.7) )

  raphael.html( fun = function( ){
    plot( x = rnorm( 100 ), y = rnorm (100 ), main = "base plot main title" )
    print( myplot )
  }, width = 5, height = 7 )
}
}
}
\seealso{
\code{\link{bsdoc}}, \code{\link{addPlot}},
\code{\link{add.plot.interactivity}} ,
\code{\link{addPlot.bsdoc}}
}

