package org.lysis.reporters.pptx4r.elements.template;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map.Entry;

import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.SlideMasterPart;
import org.lysis.reporters.tools.Debug;
import org.pptx4j.pml.Shape;

public class MasterLayoutProperties {

	public static int TITLE = 0;
	public static int FOOTER = 1;
	public static int SLIDENUMBER = 2;
	public static int DATE = 3;
	public static int SUBTITLE = 4;
	public static int CRTTITLE = 5;
	public static int BODY = 6;
	private boolean hasBeenFed = false;

	public boolean satisfied(){
		return hasBeenFed;
	}
	HashMap<Integer, ShapeDescription> listShapeDescription;
	private HashMap<Integer, Boolean> listShapeExists;

	public MasterLayoutProperties() {
		listShapeDescription = new HashMap<Integer, ShapeDescription> ();
		listShapeExists = new HashMap<Integer, Boolean> ();

		listShapeExists.put(TITLE, false);
		listShapeExists.put(FOOTER, false);
		listShapeExists.put(SLIDENUMBER, false);
		listShapeExists.put(DATE, false);
		listShapeExists.put(SUBTITLE, false);
		listShapeExists.put(CRTTITLE, false);
		listShapeExists.put(BODY, false);
		hasBeenFed = false;
	}
	
	public ShapeDescription getShapeDescription(int what){
		if( listShapeExists.containsKey(what)){
			return listShapeDescription.get(what);
		}
		return null;
	}
	
	public void feed(PresentationMLPackage basedoc) throws InvalidFormatException{
		
		Iterator<Entry<PartName, Part>> partIterator = basedoc.getParts().getParts().entrySet().iterator();
		
		while (partIterator.hasNext()) {
			Entry<PartName, Part> en =partIterator.next(); 

			if( en.getValue().getContentType().equals("application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml")){
				
				SlideMasterPart layoutPart = (SlideMasterPart)basedoc.getParts().getParts().get(new PartName(en.getKey().getName()));
				
				List<Object> slidesSet = layoutPart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame();
				Iterator<Object> itr = slidesSet.iterator();
				while(itr.hasNext()) {
					
			         Object element = itr.next();
			         if( element.getClass().equals(org.pptx4j.pml.Shape.class) ) {
			        	 Shape s = (Shape)element;
			        	 ShapeDescription sd = new ShapeDescription( s ) ;
			        	 
			        	 if( Debug.doc_explorer ) System.err.println( "shape type: " + sd.getShapeType() );

			        	 if( sd.getShapeType().equals("dt") ) {
			        		 listShapeExists.put(LayoutDescription.DATE, true);
			        		 listShapeDescription.put(LayoutDescription.DATE, sd);
			        	 } else if( sd.getShapeType().equals("title") ) {
			        		 listShapeExists.put(LayoutDescription.TITLE, true);
			        		 listShapeDescription.put(LayoutDescription.TITLE, sd);
			        	 } else if( sd.getShapeType().equals("ftr") ) {
			        		 listShapeExists.put(LayoutDescription.FOOTER, true);
			        		 listShapeDescription.put(LayoutDescription.FOOTER, sd);
			        	 } else if( sd.getShapeType().equals("sldNum") ) {
			        		 listShapeExists.put(LayoutDescription.SLIDENUMBER, true);
			        		 listShapeDescription.put(LayoutDescription.SLIDENUMBER, sd);
			        	 } else if( sd.getShapeType().equals("ctrTitle") ) {
			        		 listShapeExists.put(LayoutDescription.CRTTITLE, true);
			        		 listShapeDescription.put(LayoutDescription.CRTTITLE, sd);
			        	 } else if( sd.getShapeType().equals("subTitle") ) {
			        		 listShapeExists.put(LayoutDescription.SUBTITLE, true);
			        		 listShapeDescription.put(LayoutDescription.SUBTITLE, sd);
			        	 } else if( sd.getShapeType().equals("body") ) {
			        		 listShapeExists.put(LayoutDescription.BODY, true);
			        		 listShapeDescription.put(LayoutDescription.BODY, sd);
			        	 }
			         }
			    }
			} 
		}
		hasBeenFed = true;
	}
	
}
