% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hMeanChiSq.R
\name{hMeanChiSq}
\alias{hMeanChiSq}
\alias{hMeanChiSqMu}
\alias{hMeanChiSqCI}
\title{p-values and confidence intervals from the harmonic mean chi-squared test}
\usage{
hMeanChiSq(
  z,
  w = rep(1, length(z)),
  alternative = c("greater", "less", "two.sided", "none"),
  bound = FALSE
)

hMeanChiSqMu(
  thetahat,
  se,
  w = rep(1, length(thetahat)),
  mu = 0,
  alternative = c("greater", "less", "two.sided", "none"),
  bound = FALSE
)

hMeanChiSqCI(
  thetahat,
  se,
  w = rep(1, length(thetahat)),
  alternative = c("two.sided", "greater", "less", "none"),
  level = 0.95
)
}
\arguments{
\item{z}{Numeric vector of z-values.}

\item{w}{Numeric vector of weights.}

\item{alternative}{Either "greater" (default), "less", "two.sided", or "none".
Specifies the alternative to be considered in the computation of the p-value.}

\item{bound}{If \code{FALSE} (default), p-values that cannot be computed are reported as \code{NaN}.
If \code{TRUE}, they are reported as "> bound".}

\item{thetahat}{Numeric vector of parameter estimates.}

\item{se}{Numeric vector of standard errors.}

\item{mu}{The null hypothesis value. Defaults to 0.}

\item{level}{Numeric vector specifying the level of the confidence interval. Defaults to 0.95.}
}
\value{
\code{hMeanChiSq} returns the p-values from the harmonic mean chi-squared test
based on the study-specific z-values.

\code{hMeanChiSqMu} returns the p-value from the harmonic mean chi-squared test
based on study-specific estimates and standard errors.

\code{hMeanChiSqCI} returns confidence interval(s) from inverting the harmonic mean chi-squared test
based on study-specific estimates and standard errors. If \code{alternative} is "none",
the return value may be a set of (non-overlapping) confidence intervals.
In that case, the output is a vector of length 2n, where n is the number of confidence intervals.
}
\description{
p-values and confidence intervals from the harmonic mean chi-squared test
}
\examples{
## Example from Fisher (1999) as discussed in Held (2020)
pvalues <- c(0.0245, 0.1305, 0.00025, 0.2575, 0.128)
lower <- c(0.04, 0.21, 0.12, 0.07, 0.41)
upper <- c(1.14, 1.54, 0.60, 3.75, 1.27)
se <- ci2se(lower, upper, ratio=TRUE)
estimate <- ci2estimate(lower, upper, ratio=TRUE)

## hMeanChiSq() --------
hMeanChiSq(p2z(pvalues, alternative="less"), alternative="less")
hMeanChiSq(p2z(pvalues, alternative="less"), alternative="two.sided")
hMeanChiSq(p2z(pvalues, alternative="less"), alternative="none")

hMeanChiSq(p2z(pvalues, alternative="less"),  w=1/se^2, alternative="less")
hMeanChiSq(p2z(pvalues, alternative="less"),  w=1/se^2, alternative="two.sided")
hMeanChiSq(p2z(pvalues, alternative="less"),  w=1/se^2, alternative="none")


## hMeanChiSqMu() --------
hMeanChiSqMu(thetahat=estimate, se=se, alternative="two.sided")
hMeanChiSqMu(thetahat=estimate, se=se, w=1/se^2, alternative="two.sided")
hMeanChiSqMu(thetahat=estimate, se=se, alternative="two.sided", mu=-0.1)


## hMeanChiSqCI() --------
## two-sided
CI1 <- hMeanChiSqCI(thetahat=estimate, se=se, w=1/se^2, alternative="two.sided")
CI2 <- hMeanChiSqCI(thetahat=estimate, se=se, w=1/se^2, alternative="two.sided", level=0.99875)
## one-sided
CI1b <- hMeanChiSqCI(thetahat=estimate, se=se, w=1/se^2, alternative="less", level=0.975)
CI2b <- hMeanChiSqCI(thetahat=estimate, se=se, w=1/se^2, alternative="less", level=1-0.025^2)
## confidence intervals on hazard ratio scale
print(round(exp(CI1),2))
print(round(exp(CI2),2))
print(round(exp(CI1b),2))
print(round(exp(CI2b),2))
}
\references{
Held, L. (2020). The harmonic mean chi-squared test to substantiate scientific findings.
\emph{Journal of the Royal Statistical Society: Series C (Applied Statistics)}, \bold{69}, 697-708.
\doi{10.1111/rssc.12410}
}
\author{
Leonhard Held
}
