% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReinforcementLearning.R
\name{ReinforcementLearning}
\alias{ReinforcementLearning}
\alias{rl}
\title{Performs reinforcement learning}
\usage{
ReinforcementLearning(data, s = "s", a = "a", r = "r", s_new = "s_new",
  learningRule = "experienceReplay", iter = 1, control = list(alpha = 0.1,
  gamma = 0.1, epsilon = 0.1), verbose = F, model = NULL, ...)
}
\arguments{
\item{data}{A dataframe containing the input sequences for reinforcement learning.
Each row represents a state transition tuple \code{(s,a,r,s_new)}.}

\item{s}{A string defining the column name of the current state in \code{data}.}

\item{a}{A string defining the column name of the selected action for the current state in \code{data}.}

\item{r}{A string defining the column name of the reward in the current state in \code{data}.}

\item{s_new}{A string defining the column name of the next state in \code{data}.}

\item{learningRule}{A string defining the selected reinforcement learning agent. The default value and
only option in the current package version is \code{experienceReplay}.}

\item{iter}{(optional) Iterations to be done. iter is an integer greater than 0. By default, \code{iter} is set to 1.}

\item{control}{(optional) Control parameters defining the behavior of the agent.
Default: \code{alpha = 0.1}; \code{gamma = 0.1}; \code{epsilon = 0.1}.}

\item{verbose}{If true, progress report is shown. Default: \code{false}.}

\item{model}{(optional) Existing model of class \code{rl}. Default: \code{NULL}.}

\item{...}{Additional parameters passed to function.}
}
\value{
An object of class \code{rl} with the following components:
\describe{
  \item{\code{Q}}{Resulting state-action table.}
  \item{\code{Q_hash}}{Resulting state-action table in \code{hash} format.}
  \item{\code{Actions}}{Set of actions.}
  \item{\code{States}}{Set of states.}
  \item{\code{Policy}}{Resulting policy defining the best possible action in each state.}
  \item{\code{RewardSequence}}{Rewards collected during each learning episode in \code{iter}.}
  \item{\code{Reward}}{Total reward collected during the last learning iteration in \code{iter}.}
}
}
\description{
Performs model-free reinforcement learning. Requires input data in the form of sample sequences
consisting of states, actions and rewards. The result of the learning process is a state-action table and an
optimal policy that defines the best possible action in each state.
}
\examples{
# Sampling data (1000 grid sequences)
data <- sampleGridSequence(1000)

# Setting reinforcement learning parameters
control <- list(alpha = 0.1, gamma = 0.1, epsilon = 0.1)

# Performing reinforcement learning
model <- ReinforcementLearning(data, s = "State", a = "Action", r = "Reward",
s_new = "NextState", control = control)

# Printing model
print(model)

# Plotting learning curve
plot(model)
}
\references{
Sutton and Barto (1998). Reinforcement Learning: An Introduction, Adaptive
Computation and Machine Learning, MIT Press, Cambridge, MA.
}
