% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_reg.R
\name{vis_reg}
\alias{vis_reg}
\title{Visualize Regression Coefficients Within the Context of Empirical Data}
\usage{
vis_reg(object, ...)
}
\arguments{
\item{object}{A fitted model object, expected to be one of the following classes:
\itemize{
\item \code{lm}                 : Linear Models.
\item \verb{glm lm}             : Generalized Linear Models.
\item \verb{elnet glmnet}       : Regularized Linear Models.
\item \verb{lognet glmnet}      : Regularized Logistic Models.
\item \code{fixedLassoInf}      : Inference for the lassso for the linear models.
\item \code{fixedLogitLassoInf} : Inference for the lassso for the logistic models.
}}

\item{...}{Additional parameters.Please refer to details.}
}
\value{
A list with the following components:
\itemize{
\item \verb{$PerUnitVis}: A \code{ggplot} object that visualizes regression coefficients
on a per-unit basis
\item \verb{$RealizedEffectVis}: A \code{ggplot} object that visualizes regression
coefficients on a basis of realized effect calculation.
\item \verb{$SidebySide}: A \code{grob} object containing both visualizations side-by-side.
}
}
\description{
Typically, regression coefficients for continuous variables are interpreted
on a per-unit basis and compared against coefficients for categorical
variables. However, this method of interpretation is flawed as it
overlooks the distribution of empirical data. This visualization tool
provides a more nuanced understanding of the regression
model's dynamics, illustrating not only the immediate effect of a unit change
but also the broader implications of larger shifts such as interquartile
changes.
}
\details{
The following additional arguments can be passed:
\itemize{
\item \code{CI}: A logical value indicating whether to include Confidence Intervals.
\itemize{
\item The default is \code{FALSE}.
\item For \code{fixedLassoInf} or \code{fixedLogitLassoInf} classes it is set to \code{TRUE}.
\item \code{confint()} is used to generate CIs for the \code{lm} and \verb{glm lm} classes.
\item \verb{If CIs are desired for the regularized models, please, fit your model using }fixedLassoInf()\verb{function from the}selectiveInference\verb{package following the steps outlined in the documentation for this package and pass the object of class}fixedLassoInf\code{or}fixedLogitLassoInf`.
}
\item \code{x_data_orig}: Original non-centered and non-scaled model matrix without
intercept.
\itemize{
\item Please, pass the model matrix when CIs desired for \code{fixedLassoInf} and/or
\code{fixedLogitLassoInf} object classes with penalty factors.
\item For objects fitted without penalty factors this argument is not required
as original data can be reconstructed from the object passed.
}
\item \code{intercept}: A logical value indicating whether to include the intercept.
\itemize{
\item The default is \code{FALSE}.
\item For the regularized models it is set to \code{FALSE}.
}
\item \code{title} : Custom vectors of strings specifying titles  for both plots.
\item \code{alpha} : A numeric value between 0 and 1 specifying the significance level.
\itemize{
\item The default is 0.05.
}
\item \code{palette} : Custom vector of colors to highlight the direction of estimated
regression coefficients or Odds Ratio.
\itemize{
\item Grey scale is implemented by default.
\item Values at low and high ends of the grey scale palette can be specified.
}
\item \code{start} : grey value at low end of palette.
\itemize{
\item The default value is 0.5.
}
\item \code{end}   : grey value at high end of palette.
\itemize{
\item The default value is 0.9.
}
\item \code{eff_size_diff} : A vector specifying which values to utilize for realized
effect size calculation.It is applied to all independent variables. By
default it is c(4,2) which is Q3 - Q1. The following coding scheme is used:
\itemize{
\item 1 is the minimum.
\item 2 is the first quartile.
\item 3 is the second quartile.
\item 4 is the third quartile.
\item 5 is the maximum.
}
\item \code{round_func} : A string specifying how to round the realized effect size.
\itemize{
\item Can be either "floor", "ceiling", or "none".
\item The default value is "none".
}
\item \code{glmnet_fct_var} : names of categorical variables for regularized models.
\itemize{
\item Glmnet treats all variables as numeric.
\item If any of the variables utilized are, in fact,  categorical, please,
specify their name(s).
\item Please, note that that by default \code{model.matrix()}will create k-1
dummy variables in lieu of k levels of a categorical variable.
For example,if you have a factor variable called "sex" with two levels 0
and 1, and 0 being the base level, \code{mode.matrix()} will create a dummy
variable called "sex1". Please, utilize the names created by
\code{mode.matrix()} here and not the original factor name.
}
\item \code{verbose} : A logical value indicating whether to display warning messages.
\itemize{
\item The default is \code{FALSE}.
}
}

Please note the following:
\itemize{
\item Only \code{Gaussian} and \code{binomial} families are currently supported.
\item Certain steps should be followed in order to produce Confidence Intervals
for the regularized models. Please, refer to the vignette for the \code{vis_reg()}
function and the documentation of the \code{selectiveInference} package.
\item Penalty factor of 0 is not currently supported and no Confidence Intervals
will be produced in this case.
}
}
\examples{
# Set seed for reproducibility
set.seed(38)
# Set the number of observations
n = 1000
# Generate predictor variables
X1 = rnorm(n)
X2 = rnorm(n)
X3 = rnorm(n)
# Define coefficients for each predictor
beta_0 = -1
beta_1 = 0.5
beta_2 = -0.25
beta_3 = 0.75
# Generate the latent variable
latent_variable = beta_0 + beta_1 * X1+ beta_2 * X2 + beta_3 * X3
# convert it to probabilities
p = pnorm(latent_variable)
# Generate binomial outcomes based on these probabilities
y = rbinom(n, size = 1, prob = p)
# Fit a GLM with a probit link
glm_model <- glm(y ~ X1 + X2 + X3, family = binomial(link = "probit"),
                 data = data.frame(y, X1, X2, X3))
# Specify additional parameters and Plot Odds Ratio for the Realized Effect
vis_reg(glm_model, CI=TRUE,intercept=TRUE,
        palette=c("greenyellow","red4"))$RealizedEffectVis

}
\seealso{
\itemize{
\item \code{\link[stats]{lm}} for linear models.
\item \code{\link[stats]{glm}} for generalized linear models.
\item \code{\link[glmnet]{glmnet}} and \code{\link[glmnet]{cv.glmnet}} for
lasso and elastic-net regularized generalized linear models.
\item \code{\link[stats]{model.matrix}} for design matrices.
\item \code{\link[ggplot2]{ggplot}} for ggplot objects.
\item \code{\link[gridExtra]{arrangeGrob}} for grobs, gtables, and ggplots.
\item \code{\link[selectiveInference]{fixedLassoInf}} for post-selection inference.
}
}
