% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discoversomaticInteractions.R
\name{discoversomaticInteractions}
\alias{discoversomaticInteractions}
\title{discoversomaticInteractions}
\usage{
discoversomaticInteractions(
  maf,
  top = 25,
  genes = NULL,
  pvalue = c(0.05, 0.01),
  returnAll = TRUE,
  geneOrder = NULL,
  fontSize = 0.8,
  showSigSymbols = TRUE,
  showCounts = FALSE,
  countStats = "all",
  countType = "all",
  countsFontSize = 0.8,
  countsFontColor = "black",
  colPal = "BrBG",
  showSum = TRUE,
  colNC = 9,
  nShiftSymbols = 5,
  sigSymbolsSize = 2,
  sigSymbolsFontSize = 0.9,
  pvSymbols = c(46, 42),
  limitColorBreaks = TRUE
)
}
\arguments{
\item{maf}{maf object generated by read.maf}

\item{top}{check for interactions among top 'n' number of genes. Defaults to top 25. genes}

\item{genes}{List of genes among which interactions should be tested. If not provided, test will be performed between top 25 genes.}

\item{pvalue}{Default c(0.05, 0.01) p-value threshold. You can provide two values for upper and lower threshold.}

\item{returnAll}{If TRUE returns test statistics for all pair of tested genes. Default FALSE, returns for only genes below pvalue threshold.}

\item{geneOrder}{Plot the results in given order. Default NULL.}

\item{fontSize}{cex for gene names. Default 0.8}

\item{showSigSymbols}{Default TRUE. Heighlight significant pairs}

\item{showCounts}{Default FALSE. Include number of events in the plot}

\item{countStats}{Default 'all'. Can be 'all' or 'sig'}

\item{countType}{Default 'all'. Can be 'all', 'cooccur', 'mutexcl'}

\item{countsFontSize}{Default 0.8}

\item{countsFontColor}{Default 'black'}

\item{colPal}{colPalBrewer palettes. Default 'BrBG'. See RColorBrewer::display.brewer.all() for details}

\item{showSum}{show [sum] with gene names in plot, Default TRUE}

\item{colNC}{Number of different colors in the palette, minimum 3, default 9}

\item{nShiftSymbols}{shift if positive shift SigSymbols by n to the left, default 5}

\item{sigSymbolsSize}{size of symbols in the matrix and in legend. Default 2}

\item{sigSymbolsFontSize}{size of font in legends. Default 0.9}

\item{pvSymbols}{vector of pch numbers for symbols of p-value for upper and lower thresholds c(upper, lower). Default c(46, 42)}

\item{limitColorBreaks}{limit color to extreme values. Default TRUE}
}
\value{
A list of data.tables and it will print a heatmap with the results.
}
\description{
Function adapted to maftools where given a .maf file, it graphs the somatic interactions between a group of genes, i.e., the combination of gene expression and mutation data to detect mutually exclusive or co-ocurring events.
}
\examples{
\donttest{

  #An example of how to perform the function,
  #using data from TCGA, Colon Adenocarcinoma in this case. 
  
  coad.maf <- GDCquery_Maf("COAD", pipelines = "muse") \%>\% read.maf
  discoversomaticInteractions(maf = coad.maf, top = 35, pvalue = c(1e-2, 2e-3))

}

}
\references{
Mayakonda A, Lin DC, Assenov Y, Plass C, Koeffler HP. 2018. Maftools:
   efficient and comprehensive analysis of somatic variants in cancer.
   Genome Research. http://dx.doi.org/10.1101/gr.239244.118
}
