% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.regression.test.R
\name{p.regression.test}
\alias{p.regression.test}
\title{Probabilities of Record Regression Test}
\usage{
p.regression.test(
  X,
  record = c("upper", "lower"),
  formula = y ~ x,
  simulate.p.value = FALSE,
  B = 1000
)
}
\arguments{
\item{X}{A numeric vector, matrix (or data frame).}

\item{record}{A character string indicating the type of records to be 
calculated, "upper" or "lower".}

\item{formula}{"\code{\link{formula}}" to use in \code{\link{lm}} function, 
e.g., \code{y ~ x}, \code{y ~ poly(x, 2, raw = TRUE)}, \code{y ~ log(x)}.
By default \code{formula = y ~ x}. See Note for a caveat.}

\item{simulate.p.value}{Logical. Indicates whether to compute p-values by
Monte Carlo simulation. It is recommended if the number of columns of
\code{X} (i.e., the number of series) is lower than 12, since for lower 
values the size of the test is not fulfilled.}

\item{B}{If \code{simulate.p.value = TRUE}, an integer specifying the 
number of replicates used in the Monte Carlo estimation.}
}
\value{
A \code{"htest"} object with elements:
  \item{null.value}{Value of the coefficients under the null hypothesis
    when more than one coefficient is fitted.}
  \item{alternative}{Character string indicating the type of alternative
    hypothesis.}
  \item{method}{A character string indicating the type of test performed.}
  \item{estimate}{Value of the fitted coefficients.}
  \item{data.name}{A character string giving the name of the data.}
  \item{statistic}{Value of the \eqn{F} statistic.}
  \item{parameters}{Degrees of freedom of the \eqn{F} statistic.}
  \item{p.value}{P-value.}
}
\description{
This function performs a linear hypothesis test based on a
  regression for the record probabilities \eqn{p_t} to study the hypothesis
  of the classical record model.
}
\details{
The null hypothesis is that the data come from a population with 
  independent and identically distributed realizations. This implies that
  in all the vectors (columns in matrix \code{X}), the sample probability 
  of record at time \eqn{t} (\code{\link{p.record}}) is \eqn{1/t}, so that
  \deqn{t \, \textrm{E}(\hat p_t) = 1.} 
  Then, 
  \deqn{H_0:\,p_t = 1/t, \, t=2, ..., T \iff H_0:\,\beta_0 = 1, \, \beta_1 = 0,} 
  where \eqn{\beta_0} and \eqn{\beta_1} are the coefficients of the 
  regression model 
  \deqn{t \, \textrm{E}(\hat p_t) = \beta_0 + \beta_1 t.} 
  The  model has to be estimated by weighted least squares since the 
  response is heteroskedastic.
  
  Other models can be considered with the \code{formula} argument. 
  However, for the test to be correct, the model that assigns 1 to all 
  responses must be nested in the bigger one, either leaving the intercept 
  free or setting the intercept to 1 (see Examples for possible models).

  The \eqn{F} statistic is computed for carrying out an \eqn{F}-test-based
  comparison between the restricted model under the null hypothesis and
  the more general model (e.g., the alterantive hypothesis where 
  \eqn{t \, \textrm{E}(\hat p_t)} is a linear function of time \eqn{t}). 
  This alternative hypothesis may be reasonable in many real examples, 
  but not always.
  
  If the sample size (i.e., the number of series or columns of \code{X})
  is lower than 8 or 12 the distribution \eqn{F} is not fulfilled, so the 
  \code{simulate.p.value} option is recommended in this case.
}
\note{
IMPORTANT: In \code{formula} the intercept has to be free or fixed
  to 1 so that the test is correct.
}
\examples{
# Simple test for upper records (p-value = 0.01047)
p.regression.test(ZaragozaSeries)
# Simple test for lower records (p-value = 9.178e-05)
p.regression.test(ZaragozaSeries, record = "lower")

# Fit a 2nd term polynomial for upper records (p-value = 0.01187)
p.regression.test(ZaragozaSeries, formula = y ~ I(x^2))
# Fit a 2nd term polynomial for lower records (p-value = 8.007e-05)
p.regression.test(ZaragozaSeries, record = "lower", formula = y ~ I(x^2))

# Fix the intercept to 1 for upper records (p-value = 0.005557)
p.regression.test(ZaragozaSeries, formula = y ~ I(x-1) - 1 + offset(rep(1, length(x))))
# Fix the intercept to 1 for lower records (p-value = 2.467e-05)
p.regression.test(ZaragozaSeries, record = "lower", 
                  formula = y ~ I(x-1) - 1 + offset(rep(1, length(x))))

# Simulate p-value when the number of series is small
TxZ <- apply(series_split(TX_Zaragoza$TX), 1, max)
p.regression.test(TxZ, simulate.p.value = TRUE)
}
\seealso{
\code{\link{p.chisq.test}}, \code{\link{p.plot}}
}
\author{
Jorge Castillo-Mateo
}
