% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_reaction_vector.R
\name{calculate_reaction_vector}
\alias{calculate_reaction_vector}
\title{calculate_reaction_vector()
This is the main function of the package 'ReDirection'.}
\usage{
calculate_reaction_vector(smat, rar)
}
\arguments{
\item{smat}{An input stoichiometry matrix of a generic biochemical network.
This is a mandatory argument.}

\item{rar}{A mandatory logical argument that indicates the orientation of the
reactions as rows (TRUE) or columns (FALSE) in the stoichiometry matrix.}
}
\value{
code A numerically encoded ('0', no success; '1', success) text
message to the user and indicates the outcome of utilizing "ReDirection".
}
\description{
The input stoichiometry matrix of a generic biochemical network is checked
and modified after which the null space is computed.
}
\details{
The non-zero null space spanning and the subspace-generated unique reaction
vectors (RVs) are recursively summed combinatorially and evaluated for
redundancy.

The function compares the generated subspace vectors reaction-wise, i.e., as
sequences of identical terms across all RVs. These are then evaluated on the
basis of pre-defined criteria (descriptive statistics, linear maps, tests of
convergence, probability of occurrence, vector norms).

The output for each reaction is the combined propensity (p1-norm) of the sub-
propensities and is strictly positive. This is the probable rate constant, is
used to infer the dominant direction of each reaction and annotate a reaction
as "Forward (f)" or "Reverse (b)" or "Equivalent (e)".
Although, there is no restriction on the number of reactions, the inherent
computational complexity (NP-hard) involved per iteration suggests that an
suitable value for the number of reactions is around 20.
}
\examples{
mx <- matrix(c(1,0,0,0,0,1,0,-1,0,1,0,0,1,0,0,0,-1,1,1,0,0,0,0,0,0,-2,0,-1,
-1,1,0,0,0,0,1,0,-1,1,0,0,0,0,0,0,-1,0,1,0,-1,0,0,0,0,0,-1,0,1,0,0,-1,0,-1,0)
,byrow=TRUE,nrow=9,ncol=7)
calculate_reaction_vector(mx,TRUE)

}
