% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RelDataModel.R
\name{confront_data}
\alias{confront_data}
\title{Confront a \link{RelDataModel} to actual data}
\usage{
confront_data(
  x,
  data = list(),
  paths = NULL,
  returnData = FALSE,
  verbose = TRUE,
  n_max = Inf,
  checks = if (n_max == Inf) {
     c("unique", "not nullable", "foreign keys")
 } else
    {
     as.character()
 },
  delim = "\\t",
  ...
)
}
\arguments{
\item{x}{a \link{RelDataModel}}

\item{data}{a list of data frames to be confronted with the model.}

\item{paths}{a character vector with file paths taken into account if
the data is empty.
The file \link{basename} without extension
will be considered as the table name.}

\item{returnData}{a logical indicating if the data should be returned
with the report (default: FALSE).}

\item{verbose}{a single logical value indicating if some process information
should be displayed (default: TRUE)}

\item{n_max}{maximum number of records to read (default: Inf).}

\item{checks}{a character vector with the name of optional checks to be done
(Default: if n_max==Inf ==> all of
them c("unique", "not nullable", "foreign keys"),
else ==> none)}

\item{delim}{single character used to separate fields within a record
(default: "\\t")}

\item{...}{supplementary parameters for the \link{read_delim} function.}
}
\value{
A report as a list
}
\description{
Confront a \link{RelDataModel} to actual data
}
\examples{
## Read the model ----
hpo_model <- read_json_data_model(
   system.file("examples/HPO-model.json", package="ReDaMoR")
)
## Confront to data ----
confrontation_report <- confront_data(
   hpo_model,
   path=list.files(
      system.file("examples/HPO-subset", package="ReDaMoR"),
      full.names=TRUE
   ),
   returnData=TRUE
)
}
