% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thrasherSiteData.R
\docType{data}
\name{thrasherSiteData}
\alias{thrasherSiteData}
\title{thrasherSiteData - Sage Thrasher site data.}
\format{
A data.frame containing 120 rows and 6 columns.  Each row represents
a surveyed site (point).  Column descriptions: 
\enumerate{ 
\item \code{siteID}: Factor (120 levels), the site or point surveyed.  
\item \code{observer}: Factor (six levels), identity of the observer who surveyed
the point.  
\item \code{bare}: Number, the mean bare ground cover (\%)
within 100 m of each point.  
\item \code{herb}: Number, the mean herbaceous
cover (\%) within 100 m of each point.  
\item \code{shrub}: Number, the mean
shrub cover (\%) within 100 m of each point.  
\item \code{height}: Number,
the mean shrub height (cm) within 100 m of each point.  }
}
\source{
The Sage Thrasher data are a subset of data collected 
by Jason Carlisle and field technicians for his Ph.D. from the 
Department of Ecology, University of Wyoming, in 2017.  This portion of 
Jason's work was funded by the Wyoming Game and Fish Department through agreements 
with the University of Wyoming's  Cooperative Fish & Wildlife
Research Unit (2012).
}
\description{
Point transect data collected in central 
Wyoming from 120 points surveyed for Sage Thrashers by the Wyoming 
Cooperative Fish & Wildlife Research Unit in 2013.
See package vignettes for tutorials of the basic analysis.
}
\references{
Carlisle, J.D. 2017. The effect of sage-grouse conservation on
wildlife species of concern: implications for the umbrella species concept.
Dissertation. University of Wyoming, Laramie, Wyoming, USA.

Carlisle, J. D., A. D. Chalfoun, K. T. Smith, and J. L. Beck. 2018. 
Nontarget effects on songbirds from habitat manipulation for Greater 
Sage-Grouse: Implications for the umbrella species concept. 
\emph{The Condor: Ornithological Applications} 120:439–455. 
\doi{10.1650/CONDOR-17-200.1}
}
\seealso{
\code{\link{thrasherDetectionData}}
}
\keyword{datasets}
