% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateN.R
\name{estimateN}
\alias{estimateN}
\title{Abundance point estimates}
\usage{
estimateN(dfunc, detectionData, siteData, area = 1, bySite = FALSE)
}
\arguments{
\item{dfunc}{An estimate distance function (see \code{dfuncEstim}).}

\item{detectionData}{A data frame containing information on 
detections.  The minimum amount of information is the detection 
distances and transect or point ID where each detection
occurred. (see \emph{Input data frames} in help 
for \code{dfuncEstim}).}

\item{siteData}{A data frame containing information on the 
transects or points surveyed  (see \code{dfuncEstim}).}

\item{area}{Total area of inference, study area size, or unit conversion.
See \code{\link{abundEstim}}.}

\item{bySite}{A logical scalar indicating whether to compute site-level
estimates of abundance. The default (\code{bySite=FALSE}) returns only one
overall abundance estimate. See \bold{Value} and \bold{Details}.}
}
\value{
If \code{bySite} is FALSE, a list containing the following components:
   \item{dfunc}{The input distance function.}
   \item{abundance}{Estimated abundance in the study area (if \code{area} >
  1) or estimated density in the study area (if \code{area} = 1).}
   \item{n}{The number of detections
  (not individuals, unless all group sizes = 1) used in the estimate of
  abundance.}
   \item{area}{Total area of inference. Study area size}
   \item{esw}{Effective strip width for line-transects, effective
   radius for point-transects.  Both derived from \code{dfunc}}.
   \item{n.sites}{Total number of transects for line-transects, 
   total number of points for point-transects.}
   \item{tran.len}{Total transect length. NULL for point-transects.}
   \item{avg.group.size}{Average group size}
   
   If \code{bySite} is TRUE, a data frame containing site-level 
   estimated abundance.  The data frame is an exact copy of \code{siteData}
   with the following columns tacked onto the end:
    
   \item{effDist}{The effective sampling distance at the site.  For line-
   transects, this is ESW at the site.  For points, this is EDR. } 
   \item{pDetection}{Average probability of detection at the site. 
   If only site-level covariates appear in the distance function, 
   pDetection is constant within a site. When detection-level 
   covariates are present, pDetection is the average at the site.}
   \item{observedCount}{The total number of individuals detected at a site.}
   \item{abundance}{Estimated abundance at the site. This is the sum
   of inflated group sizes at the site. i.e., each group size 
   at the site is divided by its pDetection, and then summed.    }
   \item{density}{Estimated density at the site. This is abundance 
   at the site divided by the sampled area at the site.  E.g., for 
   line transects, this is abundance divided by \eqn{2*w*length}. For 
   points, this is abundance divided by \eqn{pi*w^2}.}
   \item{effArea}{The effective area sampled at the site. This could be used
   as an offset in a subsequent linear model. For 
   line transects, this is \eqn{2*ESW*length}. For 
   points, this is \eqn{pi*EDR^2}.}
}
\description{
Estimate abundance given a distance function, 
detection data, site data, and area.  This is called internally 
by \code{abundEstim}.  Users should use \code{abundEstim} to estimate
abundance.
}
\details{
If \code{x} is the data frame returned when \code{bySite} = TRUE, 
the following is true: 
\enumerate{
  \item For line transects, \code{sum(x$abundance)*area/(2*w*sum(x$length))}
    is the estimate of abundance on the study area or the 
    abundance estimate when \code{bySite} = FALSE.
    
  \item \code{area*sum(x$density)/nrow(x)} is the estimate of abundance 
  on the study area or the abundance estimate when \code{bySite} = FALSE.

}
}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{abundEstim}}
}
\author{
Trent McDonald, WEST Inc.,  \email{tmcdonald@west-inc.com}\cr
        Jason Carlisle, University of Wyoming and WEST Inc, \email{jcarlisle@west-inc.com}\cr
        Aidan McDonald, WEST Inc., \email{aidan@mcdcentral.org}
}
\keyword{model}
