% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary_gensamples.R
\name{aux.gensamples}
\alias{aux.gensamples}
\title{Generate model-based samples}
\usage{
aux.gensamples(
  n = 496,
  noise = 0.01,
  dname = c("swiss", "crown", "helix", "saddle", "ribbon", "bswiss", "cswiss",
    "twinpeaks", "sinusoid", "mobius", "R12in72"),
  ...
)
}
\arguments{
\item{n}{the number of points to be generated.}

\item{noise}{level of additive white noise.}

\item{dname}{name of a predefined shape. Should be one of \describe{
\item{\code{"swiss"}}{swiss roll}
\item{\code{"crown"}}{crown}
\item{\code{"helix"}}{helix}
\item{\code{"saddle"}}{manifold near saddle point}
\item{\code{"ribbon"}}{ribbon}
\item{\code{"bswiss"}}{broken swiss}
\item{\code{"cswiss"}}{cut swiss}
\item{\code{"twinpeaks"}}{two peaks}
\item{\code{"sinusoid"}}{sinusoid on the circle}
\item{\code{"mobius"}}{mobius strip embedded in \eqn{\mathbf{R}^3}}
\item{\code{"R12in72"}}{12-dimensional manifold in \eqn{\mathbf{R}^{12}}}
}}

\item{...}{extra parameters for the followings #' \tabular{lll}{
parameter \tab dname \tab description \cr
\code{ntwist} \tab \code{"mobius"} \tab number of twists
}}
}
\value{
an \eqn{(n\times p)} matrix of generated data by row. For all methods other than \code{"R12in72"}, it returns a matrix with \eqn{p=3}.
}
\description{
It generates samples from predefined shapes, set by \code{dname} parameter.
Also incorporated a functionality to add white noise with degree \code{noise}.
}
\examples{
\donttest{
## generating toy example datasets
set.seed(100)
dat.swiss = aux.gensamples(50, dname="swiss")
dat.crown = aux.gensamples(50, dname="crown")
dat.helix = aux.gensamples(50, dname="helix")
}

}
\references{
\insertRef{hein_intrinsic_2005}{Rdimtools}

\insertRef{vandermaaten_learning_2009}{Rdimtools}
}
\author{
Kisung You
}
