% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_FSCORE.R
\name{do.fscore}
\alias{do.fscore}
\title{Fisher Score}
\usage{
do.fscore(
  X,
  label,
  ndim = 2,
  preprocess = c("null", "center", "scale", "cscale", "decorrelate", "whiten")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Fisher Score (FSCORE) is a supervised linear feature extraction method. For each
feature/variable, it computes Fisher score, a ratio of between-class variance to within-class variance.
The algorithm selects variables with largest Fisher scores and returns an indicator projection matrix.
}
\examples{
## use iris data
## it is known that feature 3 and 4 are more important.
data(iris)
set.seed(100)
subid    = sample(1:150,50)
iris.dat = as.matrix(iris[subid,1:4])
iris.lab = as.factor(iris[subid,5])

## compare Fisher score with LDA
out1 = do.lda(iris.dat, iris.lab)
out2 = do.fscore(iris.dat, iris.lab)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2))
plot(out1$Y, col=iris.lab, main="LDA")
plot(out2$Y, col=iris.lab, main="Fisher Score")
par(opar)

}
\references{
\insertRef{fisher_use_1936}{Rdimtools}
}
\author{
Kisung You
}
\concept{feature_methods}
