% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_RPCAG.R
\name{do.rpcag}
\alias{do.rpcag}
\title{Robust Principal Component Analysis via Geometric Median}
\usage{
do.rpcag(
  X,
  ndim = 2,
  k = 5,
  preprocess = c("center", "scale", "cscale", "whiten", "decorrelate")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{k}{the number of subsets for \code{X} to be divided.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
This function robustifies the traditional PCA via an idea of geometric median.
To describe, the given data is first split into \code{k} subsets for each sample
covariance is attained. According to the paper, the median covariance is computed
under Frobenius norm and projection is extracted from the largest eigenvectors.
}
\examples{
## use iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.integer(iris$Species)

## try different numbers for subsets
out1 = do.rpcag(X, ndim=2, k=2)
out2 = do.rpcag(X, ndim=2, k=5)
out3 = do.rpcag(X, ndim=2, k=10)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, col=label, main="RPCAG::k=2")
plot(out2$Y, col=label, main="RPCAG::k=5")
plot(out3$Y, col=label, main="RPCAG::k=10")
par(opar)

}
\references{
\insertRef{minsker_geometric_2015}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
