% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_LPP.R
\name{do.lpp}
\alias{do.lpp}
\title{Locality Preserving Projection}
\usage{
do.lpp(
  X,
  ndim = 2,
  type = c("proportion", 0.1),
  symmetric = c("union", "intersect", "asymmetric"),
  preprocess = c("center", "scale", "cscale", "whiten", "decorrelate"),
  t = 1
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}.
See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is \code{"center"}. See also \code{\link{aux.preprocess}} for more details.}

\item{t}{bandwidth for heat kernel in \eqn{(0,\infty)}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
\code{do.lpp} is a linear approximation to Laplacian Eigenmaps. More precisely,
it aims at finding a linear approximation to the eigenfunctions of the Laplace-Beltrami
operator on the graph-approximated data manifold.
}
\examples{
## generate twinpeaks data
X <- aux.gensamples(dname="twinpeaks",n=100)

## try different kernel bandwidths
out1 <- do.lpp(X, t=0.1)
out2 <- do.lpp(X, t=1)
out3 <- do.lpp(X, t=10)

## Visualize three different projections
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, main="LPP::bandwidth=0.1")
plot(out2$Y, main="LPP::bandwidth=1")
plot(out3$Y, main="LPP::bandwidth=10")
par(opar)

}
\references{
\insertRef{he_locality_2005}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
