% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_LTSA.R
\name{do.ltsa}
\alias{do.ltsa}
\title{Local Tangent Space Alignment}
\usage{
do.ltsa(
  X,
  ndim = 2,
  type = c("proportion", 0.1),
  symmetric = c("union", "intersect", "asymmetric"),
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{eigvals}{a vector of eigenvalues from the final decomposition.}
}
}
\description{
Local Tangent Space Alignment, or LTSA in short, is a nonlinear dimensionality reduction method
that mimicks the behavior of low-dimensional manifold embedded in high-dimensional space.
Similar to LLE, LTSA computes tangent space using nearest neighbors of a given data point, and
a multiple of tangent spaces are gathered to to find an embedding that aligns the tangent spaces
in target dimensional space.
}
\examples{
\donttest{
## generate data
X <- aux.gensamples(dname="cswiss",n=100)

## 1. use 10\%-connected graph
output1 <- do.ltsa(X,ndim=2)

## 2. use 25\%-connected graph
output2 <- do.ltsa(X,ndim=2,type=c("proportion",0.25))

## 3. use 50\%-connected graph
output3 <- do.ltsa(X,ndim=2,type=c("proportion",0.50))

## Visualize three different projections
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(output1$Y, main="10\%")
plot(output2$Y, main="25\%")
plot(output3$Y, main="50\%")
par(opar)
}

}
\references{
\insertRef{zhang_linear_2007}{Rdimtools}
}
\author{
Kisung You
}
