% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_KECA.R
\name{do.keca}
\alias{do.keca}
\title{Kernel Entropy Component Analysis}
\usage{
do.keca(
  X,
  ndim = 2,
  kernel = c("gaussian", 1),
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{kernel}{a vector containing name of a kernel and corresponding parameters. See also \code{\link{aux.kernelcov}} for complete description of Kernel Trick.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{entropy}{a length-\code{ndim} vector of estimated entropy values.}
}
}
\description{
Kernel Entropy Component Analysis(KECA) is a kernel method of dimensionality reduction.
Unlike Kernel PCA(\code{\link{do.kpca}}), it utilizes eigenbasis of kernel matrix \eqn{K}
in accordance with indices of largest Renyi quadratic entropy in which entropy for
\eqn{j}-th eigenpair is defined to be \eqn{\sqrt{\lambda_j}e_j^T 1_n}, where \eqn{e_j} is
\eqn{j}-th eigenvector of an uncentered kernel matrix \eqn{K}.
}
\examples{
\donttest{
## generate ribbon-shaped data
## in order to pass CRAN pretest, n is set to be small.
X = aux.gensamples(dname="ribbon",n=100)

## 1. standard KECA with gaussian kernel
output1 <- do.keca(X,ndim=2)

## 2. gaussian kernel with large bandwidth
output2 <- do.keca(X,ndim=2,kernel=c("gaussian",5))

## 3. use laplacian kernel
output3 <- do.keca(X,ndim=2,kernel=c("laplacian",1))

## Visualize three different projections
opar = par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(output1$Y, main="Gaussian kernel")
plot(output2$Y, main="Gaussian, sigma=5")
plot(output3$Y, main="Laplacian kernel")
par(opar)
}

}
\references{
\insertRef{jenssen_kernel_2010}{Rdimtools}
}
\seealso{
\code{\link{aux.kernelcov}}
}
\author{
Kisung You
}
