% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_OLPP.R
\name{do.olpp}
\alias{do.olpp}
\title{Orthogonal Locality Preserving Projection}
\usage{
do.olpp(X, ndim = 2, type = c("proportion", 0.1), symmetric = c("union",
  "intersect", "asymmetric"), weight = TRUE, preprocess = c("center",
  "scale", "cscale", "decorrelate", "whiten"), t = 1)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}.
See also \code{\link{aux.graphnbd}} for more details.}

\item{weight}{\code{TRUE} to perform LPP on weighted graph, or \code{FALSE} otherwise.}

\item{preprocess}{an additional option for preprocessing the data. See \code{\link{aux.preprocess}} for details.}

\item{t}{bandwidth for heat kernel in \eqn{(0,\infty)}}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Orthogonal Locality Preserving Projection (OLPP) is a variant of \code{do.lpp}, which
extracts orthogonal basis functions to reconstruct the data in a more intuitive fashion.
It adopts PCA as preprocessing step and uses only one eigenvector at each iteration in that
it might incur warning messages for solving near-singular system of linear equations.
}
\examples{
\dontrun{
## generate 2 normal groups of data that are far away
X = rbind(matrix(rnorm(200),nrow=20), (matrix(rnorm(200),nrow=20)+10))

##  connecting 10\% and 25\% of data for graph construction each.
output1 <- do.olpp(X,ndim=2,type=c("proportion",0.10))
output2 <- do.olpp(X,ndim=2,type=c("proportion",0.25))

## Visualize
#  In theory, it should show two separated groups of data
par(mfrow=c(1,2))
plot(output1$Y[,1],output1$Y[,2],main="10\% connected")
plot(output2$Y[,1],output2$Y[,2],main="25\% connected")
}

}
\references{
\insertRef{cai_orthogonal_2006}{Rdimtools}
}
\seealso{
\code{\link{do.lpp}}
}
\author{
Kisung You
}
