% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_NPCA.R
\name{do.npca}
\alias{do.npca}
\title{Nonnegative Principal Component Analysis}
\usage{
do.npca(X, ndim = 2, preprocess = c("center", "decorrelate", "whiten"),
  maxiter = 1000, reltol = 1e-05)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center" and other options of "decorrelate" and "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{maxiter}{number of maximum iteraions allowed.}

\item{reltol}{stopping criterion for incremental relative error.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Nonnegative Principal Component Analysis (NPCA) is a variant of PCA where
projection vectors - or, basis for learned subspace - contain no negative values.
}
\references{
\insertRef{zafeiriou_nonnegative_2010}{Rdimtools}
}
\seealso{
\code{\link{do.pca}}
}
\author{
Kisung You
}
