% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_KMVP.R
\name{do.kmvp}
\alias{do.kmvp}
\title{Kernel-Weighted Maximum Variance Projection}
\usage{
do.kmvp(X, label, ndim = 2, preprocess = c("center", "decorrelate",
  "whiten"), kbandwidth = 1)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center" and two other options "decorrelate" and "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{kbandwidth}{bandwidth parameter for heat kernel as the equation above.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Kernel-Weighted Maximum Variance Projection (KMVP) is a generalization of
Maximum Variance Projection (MVP). Even though its name contains \emph{kernel}, it is
not related to kernel trick well known in the machine learning community. Rather, it
generalizes the binary penalization on class discrepancy,
\deqn{S_{ij} = \exp(-\|x_i-x_j\|^2/t) \quad\textrm{if}\quad C_i \ne C_j}
where \eqn{x_i} is an \eqn{i}-th data point and \eqn{t} a kernel bandwidth (\code{kbandwidth}). \bold{Note} that
when the bandwidth value is too small, it might suffer from numerical instability and rank deficiency due to its formulation.
}
\examples{
## generate 3 different groups of data X and label vector
x1 = matrix(rnorm(4*10), nrow=10)-20
x2 = matrix(rnorm(4*10), nrow=10)
x3 = matrix(rnorm(4*10), nrow=10)+20
X  = rbind(x1, x2, x3)
label = c(rep(1,10), rep(2,10), rep(3,10))

## perform KMVP with different bandwidths
out1 = do.kmvp(X, label, kbandwidth=10)
out2 = do.kmvp(X, label, kbandwidth=100)
out3 = do.kmvp(X, label, kbandwidth=1000)

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="bandwidth=1e+1")
plot(out2$Y[,1], out2$Y[,2], main="bandwidth=1e+2")
plot(out3$Y[,1], out3$Y[,2], main="bandwidth=1e+3")

}
\references{
\insertRef{zhang_maximum_2007}{Rdimtools}
}
\seealso{
\code{\link{do.mvp}}
}
\author{
Kisung You
}
