% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_SPCA.R
\name{do.spca}
\alias{do.spca}
\title{Sparse Principal Component Analysis}
\usage{
do.spca(X, ndim = 2, preprocess = c("center", "decorrelate", "whiten"),
  suppk = ceiling(ncol(X)/10))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center" and "decorrelate", or "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{suppk}{the number of nonzero elements at each principal component.
Either a number or vector of length \code{ndim} can be supplied. Note that
every element in \code{suppk} should have range of [1,p].}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are principal components.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Sparse PCA (\code{do.spca}) is a variant of PCA in that each loading - or, principal
component - should be sparse. Unlike \code{\link[elasticnet]{spca}} from \pkg{elasticnet} package,
we only support sparsity type of \code{varnum} because it is more intuitive in explaining
up to how many elements can a loading have non-zero elements. We adopted semidefinite relaxation of
the original problem and optimization is done via \pkg{CVXR}.
}
\examples{
\dontrun{
## generate default dataset and make its dimension two-folds.
Xpart <- aux.gensamples()
X <- cbind(Xpart,Xpart)

## two different choice of 'suppk'
out1 <- do.spca(X,ndim=2,suppk=1)
out2 <- do.spca(X,ndim=2,suppk=6)

## Visualize principal components
par(mfrow=c(1,2))
image(out1$projection, main="support = 1")
image(out2$projection, main="support = 6")
}

}
\references{
\insertRef{zou_sparse_2006}{Rdimtools}

\insertRef{daspremont_direct_2007}{Rdimtools}
}
\seealso{
\code{\link{do.pca}}
}
\author{
Kisung You
}
