% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{aux.gensamples}
\alias{aux.gensamples}
\title{Generate model-based samples}
\usage{
aux.gensamples(n = 496, noise = 0.1, dname = "swiss")
}
\arguments{
\item{n}{the number of points to be generated.}

\item{noise}{level of additive white noise.}

\item{dname}{name of a predefined shape. Should be one of \describe{
\item{\code{"swiss"}}{swiss roll}
\item{\code{"crown"}}{crown}
\item{\code{"helix"}}{helix}
\item{\code{"saddle"}}{manifold near saddle point}
\item{\code{"ribbon"}}{ribbon}
\item{\code{"bswiss"}}{broken swiss}
\item{\code{"cswiss"}}{cut swiss}
\item{\code{"twinpeaks"}}{two peaks}
}}
}
\value{
an \eqn{(n\times 3)} matrix of generated data by row.
}
\description{
It generates samples from predefined 3-d shapes, set by \code{dname} parameter.
Also incorporated a functionality to add white noise with degree \code{noise}.
}
\examples{
## Generate samples for three different shapes
d1 = aux.gensamples(dname="twinpeaks",noise=0.01)
d2 = aux.gensamples(dname="ribbon",noise=0.01)
d3 = aux.gensamples(dname="crown", noise=0.01)

\dontrun{
casenames = c("swiss","crown","helix","saddle","ribbon","bswiss","cswiss","twinpeaks")
for (i in 1:length(casenames)){
  data = aux.gensamples(n=sample(1000:2000,1),noise=runif(1)[1],dname=casenames[i])
}
}
}
\references{
\insertRef{van_der_maaten_dimensionality_2009}{Rdimtools}
}
\author{
Kisung You
}
