% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{aux.graphnbd}
\alias{aux.graphnbd}
\title{Find nearest neighborhood}
\usage{
aux.graphnbd(data, method = "euclidean", type = c("proportion", 0.1),
  symmetric = "union", pval = 2)
}
\arguments{
\item{data}{an \code{(n-by-p)} data matrix.}

\item{method}{type of distance to be used. See also \code{\link[stats]{dist}}.}

\item{type}{a defining pattern of neighborhood criterion. One of \describe{
\item{c("knn", k)}{knn with \code{k} a positive integer.}
\item{c("enn", radius)}{enn with a positive radius.}
\item{c("proportion", ratio)}{takes an \code{ratio} in (0,1) portion of edges to be connected.}
}}

\item{symmetric}{either ``intersect'' or ``union'' for symmetrization, or ``asymmetric''.}

\item{pval}{a \code{p}-norm option for Minkowski distance.}
}
\value{
a named list containing \describe{
\item{mask}{a binary matrix of indicating existence of an edge for each element.}
\item{dist}{corresponding distance matrix. \code{-Inf} is returned for non-connecting edges.}
}
}
\description{
Given data, it first computes pairwise distance (\code{method}) using one of measures
defined from \code{\link[stats]{dist}} function. Then, \code{type} controls how nearest neighborhood
graph should be constructed. Finally, \code{symmetric} parameter controls how
nearest neighborhood graph should be symmetrized.
}
\section{Nearest Neighbor(NN) search}{

Our package supports three ways of defining nearest neighborhood. First is
\emph{knn}, which finds \code{k} nearest points and flag them as neighbors.
Second is \emph{enn} - epsilon nearest neighbor - that connects all the
data poinst within a certain radius. Finally, \emph{proportion} flag is to
connect proportion-amount of data points sequentially from the nearest to farthest.
}

\section{Symmetrization}{

In many graph setting, it starts from dealing with undirected graphs.
NN search, however, does not necessarily guarantee if symmetric connectivity
would appear or not. There are two easy options for symmetrization;
\code{intersect} for connecting two nodes if both of them are
nearest neighbors of each other and \code{union} for only either of them to be present.
}

\examples{
## Generate data
X = aux.gensamples()

## Test three different types of neighborhood connectivity
nn1 = aux.graphnbd(X,type=c("knn",20))         # knn with k=20
nn2 = aux.graphnbd(X,type=c("enn",1))          # enn with radius = 1
nn3 = aux.graphnbd(X,type=c("proportion",0.4)) # connecting 40\% of edges

## Visualize
par(mfrow=c(1,3))
image(nn1$mask); title("knn with k=20")
image(nn2$mask); title("enn with radius=1")
image(nn3$mask); title("proportion of ratio=0.4")

}
\author{
Kisung You
}
