% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchy.R
\name{parents}
\alias{parents}
\alias{ancestors}
\alias{children}
\alias{descendants}
\title{Ancestors and descendants of SNOMED CT concepts}
\usage{
parents(conceptIds, include_self = FALSE, SNOMED = getSNOMED(), ...)

ancestors(conceptIds, include_self = FALSE, SNOMED = getSNOMED(), ...)

children(conceptIds, include_self = FALSE, SNOMED = getSNOMED(), ...)

descendants(conceptIds, include_self = FALSE, SNOMED = getSNOMED(), ...)
}
\arguments{
\item{conceptIds}{character or integer64 vector of SNOMED concept IDs}

\item{include_self}{whether to include the original concept(s) in the
output, default = FALSE}

\item{SNOMED}{environment containing a SNOMED dictionary}

\item{...}{other arguments to pass to relatedConcepts}
}
\value{
a bit64 vector of SNOMED CT concepts
}
\description{
Returns concepts with 'Is a' or inverse 'Is a'
relationship with a set of target concepts. 
Ancestors include parents and all higher relations.
Descendants include children and all lower relations.
}
\examples{
SNOMED <- sampleSNOMED()

parents('Heart failure')
children('Heart failure')
ancestors('Heart failure')
descendants('Heart failure')
}
