% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchy.R
\name{attrConcept}
\alias{attrConcept}
\title{Retrieve all attributes of a set of SNOMED CT concepts}
\usage{
attrConcept(
  conceptIds,
  SNOMED = getSNOMED(),
  tables = c("RELATIONSHIP", "STATEDRELATIONSHIP")
)
}
\arguments{
\item{conceptIds}{character or integer64 vector of SNOMED concept IDs}

\item{SNOMED}{environment containing a SNOMED dictionary}

\item{tables}{character vector of relationship tables to use}
}
\value{
a data.table with the following columns: 
  sourceId (concept ID of source for relationship),
  destinationId (concept ID of source for relationship),
  typeId (concept ID of relationship type),
  typeName (description of relationship type)
}
\description{
Returns the portion of the SNOMED CT relationship tables containing
relationships where the given concepts are either the source or the 
destination.
}
\examples{
SNOMED <- sampleSNOMED()

attrConcept(as.SNOMEDconcept('Heart failure'))
}
