% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcurvep_onerun.R
\name{run_rcurvep}
\alias{run_rcurvep}
\title{Run Curvep on datasets of concentration-response data}
\usage{
run_rcurvep(
  d,
  mask = 0,
  config = curvep_defaults(),
  keep_sets = c("act_set", "resp_set", "fp_set"),
  ...
)
}
\arguments{
\item{d}{Datasets with columns: endpoint, chemical, conc, and resp, mask (optional)
Example datasets as \link{zfishbeh}.
It is required that the baseline of responses in the resp column to be 0.}

\item{mask}{Default = 0, for no mask (values in the mask column all 0).
Use a vector of integers to mask the responses:
1 to mask the response at the highest concentration;
2 to mask the response at the second highest concentration, and so on.
If mask column exists, the setting will be ignored.}

\item{config}{Default configurations set by \code{\link[=curvep_defaults]{curvep_defaults()}}.}

\item{keep_sets}{The types of output to be reported.
Allowed values: act_set, resp_set, fp_set. Multiple values are allowed.
act_set is the must.
\itemize{
\item act_set: activity data
\item resp_set: response data
\item fp_set: fingerprint data
}}

\item{...}{Curvep settings.
See \code{\link[=curvep_defaults]{curvep_defaults()}} for allowed parameters.
These can be used to overwrite the default values.}
}
\value{
An rcurvep object. It has two components: result, config
The result component is also a list of output sets depending on the parameter, \emph{keep_sets}.
The config component is a \emph{curvep_config} object.\cr

Often used columns in the \emph{act_set}: AUC (area under the curve), wAUC (weighted AUC),
POD (point-of-departure), EC50 (Half maximal effective concentration),
nCorrected (number of corrected points).
}
\description{
The concentration-response relationship per endpoint and chemical has to be 1-to-1.
If not, use \code{\link[=create_dataset]{create_dataset()}} for pre-processing or
use \code{\link[=combi_run_rcurvep]{combi_run_rcurvep()}}, which has both pre-processing and more flexible parameter controls.
}
\examples{

data(zfishbeh)
d <- create_dataset(zfishbeh)

# default
out <- run_rcurvep(d)

# change TRSH
out <- run_rcurvep(d, TRSH = 30)

# mask response at highest and second highest concentration
out <- run_rcurvep(d, mask = c(1, 2))


}
\seealso{
\code{\link[=create_dataset]{create_dataset()}}, \code{\link[=combi_run_rcurvep]{combi_run_rcurvep()}}, \code{\link[=curvep_defaults]{curvep_defaults()}}.
}
