% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getPackages}
\alias{getPackages}
\title{Retrieve Names of All Installable Packages}
\usage{
getPackages(regexp = ".")
}
\arguments{
\item{regexp}{A regular expression for the package name(s) with a
default of all (".").}
}
\value{
A data frame with columns containing the
package name, the installed version (or NA if not installed)
and the section it is installed in (or NA).
}
\description{
The APT Package Management system uses a data-rich caching
structure. This accessor function returns the names of installable
packages for a given regular expression.
}
\details{
Note that the package lookup uses regular expressions. If only a
single package is desired, append a single \code{$} to terminate
the expression.  \emph{Ie} \code{r-cran-rcpp$} will \emph{not}
return results for \code{r-cran-rcpparmadillo} and
\code{r-cran-rcppeigen}.
}
\examples{
getPackages("^r-(base|doc)-")
}
\author{
Dirk Eddelbuettel
}

