# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' The APT Package Management system uses a data-rich caching 
#' structure. This accessor function returns the names of installable
#' packages for a given regular expression.
#'
#' @title Retrieve Names of All Installable Packages
#' @param regexp Regular expression for package name
#' @return A data frame with columns containing the 
#' package name, the installed version (or NA if not installed)  
#' and the section it is installed in (or NA).
#' @author Dirk Eddelbuettel
#' @examples 
#' getPackages("^r-(base|doc)-")
getPackages <- function(regexp = ".") {
    .Call('RcppAPT_getPackages', PACKAGE = 'RcppAPT', regexp)
}

#' The APT Package Management system uses a data-rich caching
#' structure. This accessor function tests whether a given package
#' exists.
#' @title Test for Existence of Given Package
#' @param pkg A character vector with name of the package
#' @return A boolean result vector is returned indicating if the 
#' package at the given position is available.
#' @author Dirk Eddelbuettel
#' @examples
#' hasPackages(c("r-base-core", "somethingThatDoesNotExist"))
hasPackages <- function(pkg) {
    .Call('RcppAPT_hasPackages', PACKAGE = 'RcppAPT', pkg)
}

